/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.malware.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.httpclient.HttpClientProviderFactory;
import com.sap.cds.feature.attachments.service.malware.client.model.MalwareScanResult;
import com.sap.cds.feature.attachments.service.malware.client.model.MalwareScanResultStatus;
import com.sap.cds.feature.attachments.utilities.LoggingMarker;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClientResponseException;
import com.sap.cds.services.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class DefaultMalwareScanClient
implements MalwareScanClient {
    private static final String JSON_CONTENT = "application/json";
    private static final Logger logger = LoggerFactory.getLogger(DefaultMalwareScanClient.class);
    private static final Marker marker = LoggingMarker.MALWARE_SCANNER.getMarker();
    private final ObjectMapper mapper = DefaultMalwareScanClient.buildObjectMapper();
    private final HttpClientProviderFactory clientProviderFactory;

    public DefaultMalwareScanClient(HttpClientProviderFactory clientProviderFactory) {
        this.clientProviderFactory = clientProviderFactory;
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @Override
    public MalwareScanResultStatus scanContent(InputStream content) {
        if (!this.clientProviderFactory.isServiceBound()) {
            logger.warn(marker, "No malware scanner service bound, never use this in productive environment!");
            return MalwareScanResultStatus.NO_SCANNER;
        }
        logger.info(marker, "Start scanning document");
        return this.scanContentWithClient(content);
    }

    private MalwareScanResultStatus scanContentWithClient(InputStream content) {
        HttpClient httpClient = this.clientProviderFactory.getHttpClientProvider().get();
        HttpPost request = this.buildHttpRequest(content);
        return this.executeRequest(httpClient, request);
    }

    private HttpPost buildHttpRequest(InputStream content) {
        InputStreamEntity reqEntity = new InputStreamEntity(content, -1L);
        reqEntity.setContentType("binary/octet-stream");
        reqEntity.setChunked(true);
        HttpPost request = new HttpPost();
        request.setEntity((HttpEntity)reqEntity);
        return request;
    }

    private MalwareScanResultStatus executeRequest(HttpClient httpClient, HttpPost request) {
        MalwareScanResultStatus malwareScanResultStatus;
        block8: {
            CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);
            try {
                MalwareScanResult malwareScanResult = this.convertHttpResponseToJavaObject(response);
                malwareScanResultStatus = this.mapResponseToStatus(malwareScanResult);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            response.close();
        }
        return malwareScanResultStatus;
    }

    private MalwareScanResult convertHttpResponseToJavaObject(CloseableHttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        logger.debug("Server responded with status code '{}'", (Object)code);
        if (code >= 200 && code <= 207) {
            String contentType = JSON_CONTENT;
            if (response.getEntity() != null) {
                if (Objects.nonNull(response.getEntity().getContentType())) {
                    contentType = response.getEntity().getContentType().getValue();
                }
                if (contentType.contains(JSON_CONTENT)) {
                    String jsonData = EntityUtils.toString((HttpEntity)response.getEntity());
                    return (MalwareScanResult)this.mapper.readValue(jsonData, MalwareScanResult.class);
                }
                throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
            }
            return (MalwareScanResult)this.mapper.readValue("{}", MalwareScanResult.class);
        }
        String reason = response.getStatusLine().getReasonPhrase();
        throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
    }

    private MalwareScanResultStatus mapResponseToStatus(MalwareScanResult responseJson) {
        if (responseJson.isMalwareDetected() || responseJson.isEncryptedContentDetected()) {
            logger.warn("Document is infected with malware, response status from scan was: malwareDetected = {}, encryptedContentDetected = {}", (Object)responseJson.isMalwareDetected(), (Object)responseJson.isEncryptedContentDetected());
            return MalwareScanResultStatus.INFECTED;
        }
        logger.info("Document is clean");
        return MalwareScanResultStatus.CLEAN;
    }
}

