/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.malware.client.httpclient;

import com.sap.cds.feature.attachments.service.malware.client.httpclient.HttpClientProviderFactory;
import com.sap.cds.integration.cloudsdk.destination.HttpClientProvider;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

public class MalwareScanClientProviderFactory
implements HttpClientProviderFactory {
    private static final String SCAN_ENDPOINT = "/scan";
    private static final String VALUE_URL = "url";
    private static final String VALUE_USERNAME = "username";
    private static final String VALUE_PASSWORD = "password";
    private final HttpClientProvider clientProvider;
    private final boolean serviceBound;

    public MalwareScanClientProviderFactory(ServiceBinding binding, CdsRuntime runtime, CdsProperties.ConnectionPool connectionPoolConfig) {
        if (Objects.isNull(binding)) {
            this.serviceBound = false;
            this.clientProvider = null;
        } else {
            Map credentials = binding.getCredentials();
            String url = (String)credentials.get(VALUE_URL);
            URI serviceUrl = URI.create(url + SCAN_ENDPOINT).normalize();
            BasicCredentials basic = new BasicCredentials((String)credentials.get(VALUE_USERNAME), (String)credentials.get(VALUE_PASSWORD));
            DefaultHttpDestination destination = DefaultHttpDestination.builder((URI)serviceUrl).name("malware-scanner").basicCredentials(basic).build();
            this.clientProvider = new HttpClientProvider((HttpDestination)destination, connectionPoolConfig, runtime);
            this.serviceBound = true;
        }
    }

    @Override
    public HttpClientProvider getHttpClientProvider() {
        return this.clientProvider;
    }

    @Override
    public boolean isServiceBound() {
        return this.serviceBound;
    }
}

