/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.configuration;

import com.sap.cds.feature.attachments.handler.applicationservice.CreateAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.DeleteAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.ReadAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.UpdateAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ThreadLocalDataStorage;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.CreateAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.DoNothingAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.MarkAsDeletedAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.UpdateAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.readhelper.AttachmentStatusValidator;
import com.sap.cds.feature.attachments.handler.applicationservice.transaction.CreationChangeSetListener;
import com.sap.cds.feature.attachments.handler.applicationservice.transaction.ListenerProvider;
import com.sap.cds.feature.attachments.handler.common.AssociationCascader;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.handler.draftservice.DraftActiveAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.draftservice.DraftCancelAttachmentsHandler;
import com.sap.cds.feature.attachments.handler.draftservice.DraftPatchAttachmentsHandler;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.AttachmentsServiceImpl;
import com.sap.cds.feature.attachments.service.handler.DefaultAttachmentsServiceHandler;
import com.sap.cds.feature.attachments.service.handler.transaction.EndTransactionMalwareScanProvider;
import com.sap.cds.feature.attachments.service.handler.transaction.EndTransactionMalwareScanRunner;
import com.sap.cds.feature.attachments.service.malware.DefaultAttachmentMalwareScanner;
import com.sap.cds.feature.attachments.service.malware.client.DefaultMalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanClientProvider;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.environment.CdsEnvironment;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.outbox.OutboxService;
import com.sap.cds.services.persistence.PersistenceService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registration
implements CdsRuntimeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(Registration.class);

    public void services(CdsRuntimeConfigurer configurer) {
        configurer.service((Service)new AttachmentsServiceImpl());
    }

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        AttachmentService outboxedAttachmentService;
        logger.debug("Registering event handlers");
        CdsRuntime runtime = configurer.getCdsRuntime();
        ServiceCatalog serviceCatalog = runtime.getServiceCatalog();
        PersistenceService persistenceService = (PersistenceService)serviceCatalog.getService(PersistenceService.class, "PersistenceService$Default");
        AttachmentService attachmentService = (AttachmentService)serviceCatalog.getService(AttachmentService.class, "AttachmentService$Default");
        OutboxService outboxService = (OutboxService)serviceCatalog.getService(OutboxService.class, "DefaultOutboxUnordered");
        if (outboxService != null) {
            outboxedAttachmentService = (AttachmentService)outboxService.outboxed((Service)attachmentService);
        } else {
            outboxedAttachmentService = attachmentService;
            logger.warn("OutboxService '{}' is not available. AttachmentService will not be outboxed.", (Object)"DefaultOutboxUnordered");
        }
        MalwareScanClient scanClient = Registration.buildMalwareScanClient(runtime.getEnvironment());
        DefaultAttachmentMalwareScanner malwareScanner = new DefaultAttachmentMalwareScanner(persistenceService, attachmentService, scanClient);
        EndTransactionMalwareScanProvider malwareScanEndTransactionListener = (attachmentEntity, contentId) -> new EndTransactionMalwareScanRunner(attachmentEntity, contentId, malwareScanner, runtime);
        configurer.eventHandler((Object)new DefaultAttachmentsServiceHandler(malwareScanEndTransactionListener));
        MarkAsDeletedAttachmentEvent deleteEvent = new MarkAsDeletedAttachmentEvent(outboxedAttachmentService);
        ModifyAttachmentEventFactory eventFactory = Registration.buildAttachmentEventFactory(attachmentService, deleteEvent, outboxedAttachmentService);
        AttachmentsReader attachmentsReader = new AttachmentsReader(new AssociationCascader(), persistenceService);
        ThreadLocalDataStorage storage = new ThreadLocalDataStorage();
        boolean hasApplicationServices = serviceCatalog.getServices(ApplicationService.class).findFirst().isPresent();
        if (hasApplicationServices) {
            configurer.eventHandler((Object)new CreateAttachmentsHandler(eventFactory, storage));
            configurer.eventHandler((Object)new UpdateAttachmentsHandler(eventFactory, attachmentsReader, outboxedAttachmentService, storage));
            configurer.eventHandler((Object)new DeleteAttachmentsHandler(attachmentsReader, deleteEvent));
            EndTransactionMalwareScanRunner scanRunner = new EndTransactionMalwareScanRunner(null, null, malwareScanner, runtime);
            configurer.eventHandler((Object)new ReadAttachmentsHandler(attachmentService, new AttachmentStatusValidator(), scanRunner));
        } else {
            logger.debug("No application service is available. Application service event handlers will not be registered.");
        }
        boolean hasDraftServices = serviceCatalog.getServices(DraftService.class).findFirst().isPresent();
        if (hasDraftServices) {
            configurer.eventHandler((Object)new DraftPatchAttachmentsHandler(persistenceService, eventFactory));
            configurer.eventHandler((Object)new DraftCancelAttachmentsHandler(attachmentsReader, deleteEvent));
            configurer.eventHandler((Object)new DraftActiveAttachmentsHandler(storage));
        } else {
            logger.debug("No draft service is available. Draft event handlers will not be registered.");
        }
    }

    private static MalwareScanClient buildMalwareScanClient(CdsEnvironment environment) {
        Optional<ServiceBinding> bindingOpt = environment.getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)"malware-scanner")).findFirst();
        if (bindingOpt.isPresent()) {
            ServiceBinding binding = bindingOpt.get();
            CdsProperties.ConnectionPool connectionPool = Registration.getConnectionPool(environment);
            MalwareScanClientProvider clientProvider = new MalwareScanClientProvider(binding, connectionPool);
            if (logger.isInfoEnabled()) {
                logger.info("Using Malware Scanning service binding with name '{}' and plan '{}' for malware scanning of attachments.", (Object)binding.getName().orElse("unknown"), (Object)binding.getServicePlan().orElse("unknown"));
            }
            return new DefaultMalwareScanClient(clientProvider);
        }
        logger.info("No Malware Scanning service binding found, malware scanning is disabled.");
        return null;
    }

    private static ModifyAttachmentEventFactory buildAttachmentEventFactory(AttachmentService attachmentService, MarkAsDeletedAttachmentEvent deleteEvent, AttachmentService outboxedAttachmentService) {
        ListenerProvider listenerProvider = (contentId, cdsRuntime) -> new CreationChangeSetListener(contentId, cdsRuntime, outboxedAttachmentService);
        CreateAttachmentEvent createEvent = new CreateAttachmentEvent(attachmentService, listenerProvider);
        UpdateAttachmentEvent updateEvent = new UpdateAttachmentEvent(createEvent, deleteEvent);
        DoNothingAttachmentEvent doNothingEvent = new DoNothingAttachmentEvent();
        return new ModifyAttachmentEventFactory(createEvent, updateEvent, deleteEvent, doNothingEvent);
    }

    private static CdsProperties.ConnectionPool getConnectionPool(CdsEnvironment env) {
        String prefix = "cds.attachments.malwareScanner.http.%s";
        Duration timeout = Duration.ofSeconds(((Integer)env.getProperty("cds.attachments.malwareScanner.http.%s".formatted("timeout"), Integer.class, (Object)120)).intValue());
        int maxConnections = (Integer)env.getProperty("cds.attachments.malwareScanner.http.%s".formatted("maxConnections"), Integer.class, (Object)20);
        logger.debug("Connection pool configuration: timeout={}, maxConnections={}", (Object)timeout, (Object)maxConnections);
        return new CdsProperties.ConnectionPool(timeout, Integer.valueOf(maxConnections), Integer.valueOf(maxConnections));
    }
}

