/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ModifyApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ReadonlyDataContextEnhancer;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ThreadDataStorageReader;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsCreateEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class CreateAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateAttachmentsHandler.class);
    private final ModifyAttachmentEventFactory eventFactory;
    private final ThreadDataStorageReader storageReader;

    public CreateAttachmentsHandler(ModifyAttachmentEventFactory eventFactory, ThreadDataStorageReader storageReader) {
        this.eventFactory = Objects.requireNonNull(eventFactory, "eventFactory must not be null");
        this.storageReader = Objects.requireNonNull(storageReader, "storageReader must not be null");
    }

    @Before
    @HandlerOrder(value=-10500)
    void processBeforeForDraft(CdsCreateEventContext context, List<CdsData> data) {
        ReadonlyDataContextEnhancer.preserveReadonlyFields(context.getTarget(), data, this.storageReader.get());
    }

    @Before
    @HandlerOrder(value=10000)
    void processBefore(CdsCreateEventContext context, List<CdsData> data) {
        if (ApplicationHandlerHelper.containsContentField(context.getTarget(), data)) {
            logger.debug("Processing before {} event for entity {}", (Object)context.getEvent(), (Object)context.getTarget());
            ModifyApplicationHandlerHelper.handleAttachmentForEntities(context.getTarget(), data, new ArrayList<Attachments>(), this.eventFactory, (EventContext)context);
        }
    }
}

