/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.MarkAsDeletedAttachmentEvent;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsDeleteEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class DeleteAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteAttachmentsHandler.class);
    private final AttachmentsReader attachmentsReader;
    private final MarkAsDeletedAttachmentEvent deleteEvent;

    public DeleteAttachmentsHandler(AttachmentsReader attachmentsReader, MarkAsDeletedAttachmentEvent deleteEvent) {
        this.attachmentsReader = Objects.requireNonNull(attachmentsReader, "attachmentsReader must not be null");
        this.deleteEvent = Objects.requireNonNull(deleteEvent, "deleteEvent must not be null");
    }

    @Before
    @HandlerOrder(value=10000)
    void processBefore(CdsDeleteEventContext context) {
        logger.debug("Processing before {} event for entity {}", (Object)context.getEvent(), (Object)context.getTarget());
        List<Attachments> attachments = this.attachmentsReader.readAttachments(context.getModel(), context.getTarget(), (CqnFilterableStatement)context.getCqn());
        CdsDataProcessor.Converter converter = (path, element, value) -> this.deleteEvent.processEvent(path, (InputStream)value, Attachments.of(path.target().values()), (EventContext)context);
        CdsDataProcessor.create().addConverter(ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter).process(attachments, (CdsStructuredType)context.getTarget());
    }
}

