/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.readhelper.AttachmentStatusValidator;
import com.sap.cds.feature.attachments.handler.applicationservice.readhelper.BeforeReadItemsModifier;
import com.sap.cds.feature.attachments.handler.applicationservice.readhelper.LazyProxyInputStream;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.malware.AsyncMalwareScanExecutor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class ReadAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReadAttachmentsHandler.class);
    private final AttachmentService attachmentService;
    private final AttachmentStatusValidator statusValidator;
    private final AsyncMalwareScanExecutor scanExecutor;

    public ReadAttachmentsHandler(AttachmentService attachmentService, AttachmentStatusValidator statusValidator, AsyncMalwareScanExecutor scanExecutor) {
        this.attachmentService = Objects.requireNonNull(attachmentService, "attachmentService must not be null");
        this.statusValidator = Objects.requireNonNull(statusValidator, "statusValidator must not be null");
        this.scanExecutor = Objects.requireNonNull(scanExecutor, "scanExecutor must not be null");
    }

    @Before
    @HandlerOrder(value=-10000)
    void processBefore(CdsReadEventContext context) {
        logger.debug("Processing before {} for entity {}.", (Object)context.getEvent(), (Object)context.getTarget());
        CdsModel cdsModel = context.getModel();
        List<String> fieldNames = this.getAttachmentAssociations(cdsModel, context.getTarget(), "", new ArrayList<String>());
        if (!fieldNames.isEmpty()) {
            CqnSelect resultCqn = (CqnSelect)CQL.copy((CqnStatement)context.getCqn(), (Modifier)new BeforeReadItemsModifier(fieldNames));
            context.setCqn(resultCqn);
        }
    }

    @After
    @HandlerOrder(value=-10000)
    void processAfter(CdsReadEventContext context, List<CdsData> data) {
        if (ApplicationHandlerHelper.containsContentField(context.getTarget(), data)) {
            logger.debug("Processing after {} event for entity {}", (Object)context.getEvent(), (Object)context.getTarget());
            CdsDataProcessor.Converter converter = (path, element, value) -> {
                Attachments attachment = Attachments.of(path.target().values());
                InputStream content = attachment.getContent();
                if (Objects.nonNull(attachment.getContentId())) {
                    this.verifyStatus(path, attachment);
                    Supplier<InputStream> supplier = Objects.nonNull(content) ? () -> content : () -> this.attachmentService.readAttachment(attachment.getContentId());
                    return new LazyProxyInputStream(supplier, this.statusValidator, attachment.getStatus());
                }
                return value;
            };
            CdsDataProcessor.create().addConverter(ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter).process(data, (CdsStructuredType)context.getTarget());
        }
    }

    private List<String> getAttachmentAssociations(CdsModel model, CdsEntity entity, String associationName, List<String> processedEntities) {
        Map<String, CdsEntity> annotatedEntities;
        ArrayList<String> associationNames = new ArrayList<String>();
        if (ApplicationHandlerHelper.isMediaEntity((CdsStructuredType)entity)) {
            associationNames.add(associationName);
        }
        if ((annotatedEntities = entity.associations().collect(Collectors.toMap(CdsElementDefinition::getName, element -> ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTarget()))).isEmpty()) {
            return associationNames;
        }
        for (Map.Entry<String, CdsEntity> associatedElement : annotatedEntities.entrySet()) {
            if (associationNames.contains(associatedElement.getKey()) || processedEntities.contains(associatedElement.getKey()) || "SiblingEntity".equals(associatedElement.getKey())) continue;
            processedEntities.add(associatedElement.getKey());
            List<String> result = this.getAttachmentAssociations(model, associatedElement.getValue(), associatedElement.getKey(), processedEntities);
            associationNames.addAll(result);
        }
        return associationNames;
    }

    private void verifyStatus(Path path, Attachments attachment) {
        if (this.areKeysEmpty(path.target().keys())) {
            String currentStatus = attachment.getStatus();
            logger.debug("In verify status for content id {} and status {}", (Object)attachment.getContentId(), (Object)currentStatus);
            if ("Unscanned".equals(currentStatus) || "Scanning".equals(currentStatus) || currentStatus == null) {
                logger.debug("Scanning content with ID {} for malware, has current status {}", (Object)attachment.getContentId(), (Object)currentStatus);
                this.scanExecutor.scanAsync(path.target().entity(), attachment.getContentId());
            }
            this.statusValidator.verifyStatus(attachment.getStatus());
        }
    }

    private boolean areKeysEmpty(Map<String, Object> keys) {
        return keys.values().stream().allMatch(Objects::isNull);
    }
}

