/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ModifyApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ReadonlyDataContextEnhancer;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ThreadDataStorageReader;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.MarkAsDeletedInput;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsUpdateEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.utils.model.CqnUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={ApplicationService.class})
public class UpdateAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateAttachmentsHandler.class);
    private final ModifyAttachmentEventFactory eventFactory;
    private final AttachmentsReader attachmentsReader;
    private final AttachmentService attachmentService;
    private final ThreadDataStorageReader storageReader;

    public UpdateAttachmentsHandler(ModifyAttachmentEventFactory eventFactory, AttachmentsReader attachmentsReader, AttachmentService attachmentService, ThreadDataStorageReader storageReader) {
        this.eventFactory = Objects.requireNonNull(eventFactory, "eventFactory must not be null");
        this.attachmentsReader = Objects.requireNonNull(attachmentsReader, "attachmentsReader must not be null");
        this.attachmentService = Objects.requireNonNull(attachmentService, "attachmentService must not be null");
        this.storageReader = Objects.requireNonNull(storageReader, "storageReader must not be null");
    }

    @Before
    @HandlerOrder(value=-10500)
    void processBeforeForDraft(CdsUpdateEventContext context, List<CdsData> data) {
        ReadonlyDataContextEnhancer.preserveReadonlyFields(context.getTarget(), data, this.storageReader.get());
    }

    @Before
    @HandlerOrder(value=10000)
    void processBefore(CdsUpdateEventContext context, List<CdsData> data) {
        CdsEntity target = context.getTarget();
        boolean associationsAreUnchanged = this.associationsAreUnchanged(target, data);
        if (ApplicationHandlerHelper.containsContentField(target, data) || !associationsAreUnchanged) {
            logger.debug("Processing before {} event for entity {}", (Object)context.getEvent(), (Object)target);
            Select select = CqnUtils.toSelect((CqnUpdate)context.getCqn(), (CdsEntity)context.getTarget());
            List<Attachments> attachments = this.attachmentsReader.readAttachments(context.getModel(), target, (CqnFilterableStatement)select);
            List<Attachments> condensedAttachments = ApplicationHandlerHelper.condenseAttachments(attachments, target);
            ModifyApplicationHandlerHelper.handleAttachmentForEntities(target, data, condensedAttachments, this.eventFactory, (EventContext)context);
            if (!associationsAreUnchanged) {
                this.deleteRemovedAttachments(attachments, data, target, context.getUserInfo());
            }
        }
    }

    private boolean associationsAreUnchanged(CdsEntity entity, List<CdsData> data) {
        return entity.compositions().noneMatch(association -> data.stream().anyMatch(d -> d.containsKey((Object)association.getName())));
    }

    private void deleteRemovedAttachments(List<Attachments> existingAttachments, List<CdsData> data, CdsEntity entity, UserInfo userInfo) {
        List<Attachments> condensedAttachments = ApplicationHandlerHelper.condenseAttachments(data, entity);
        CdsDataProcessor.Validator validator = (path, element, value) -> {
            Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKey(path.target().keys());
            boolean entryExists = condensedAttachments.stream().anyMatch(updatedData -> ApplicationHandlerHelper.areKeysInData(keys, updatedData));
            if (!entryExists) {
                String contentId = (String)path.target().values().get("contentId");
                this.attachmentService.markAttachmentAsDeleted(new MarkAsDeletedInput(contentId, userInfo));
            }
        };
        CdsDataProcessor.create().addValidator(ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, validator).process(existingAttachments, (CdsStructuredType)entity);
    }
}

