/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.helper;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ReadonlyDataContextEnhancer;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public final class ModifyApplicationHandlerHelper {
    public static void handleAttachmentForEntities(CdsEntity entity, List<CdsData> data, List<Attachments> existingAttachments, ModifyAttachmentEventFactory eventFactory, EventContext eventContext) {
        CdsDataProcessor.Converter converter = (path, element, value) -> ModifyApplicationHandlerHelper.handleAttachmentForEntity(existingAttachments, eventFactory, eventContext, path, (InputStream)value);
        CdsDataProcessor.create().addConverter(ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter).process(data, (CdsStructuredType)entity);
    }

    public static InputStream handleAttachmentForEntity(List<Attachments> existingAttachments, ModifyAttachmentEventFactory eventFactory, EventContext eventContext, Path path, InputStream content) {
        Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKey(path.target().keys());
        ReadonlyDataContextEnhancer.restoreReadonlyFields((CdsData)path.target().values());
        Attachments attachment = ModifyApplicationHandlerHelper.getExistingAttachment(keys, existingAttachments);
        String contentId = (String)path.target().values().get("contentId");
        ModifyAttachmentEvent eventToProcess = eventFactory.getEvent(content, contentId, attachment);
        return eventToProcess.processEvent(path, content, attachment, eventContext);
    }

    private static Attachments getExistingAttachment(Map<String, Object> keys, List<Attachments> existingAttachments) {
        return existingAttachments.stream().filter(existingData -> ApplicationHandlerHelper.areKeysInData(keys, existingData)).findAny().orElse(Attachments.create());
    }

    private ModifyApplicationHandlerHelper() {
    }
}

