/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.helper;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.List;
import java.util.Objects;

public final class ReadonlyDataContextEnhancer {
    private static final String DRAFT_READONLY_CONTEXT = "DRAFT_READONLY_CONTEXT";

    public static void preserveReadonlyFields(CdsEntity target, List<CdsData> data, boolean isDraft) {
        CdsDataProcessor.Validator validator = (path, element, value) -> {
            if (isDraft) {
                Attachments values = Attachments.of(path.target().values());
                Attachments attachment = Attachments.create();
                attachment.setContentId(values.getContentId());
                attachment.setStatus(values.getStatus());
                attachment.setScannedAt(values.getScannedAt());
                path.target().values().put(DRAFT_READONLY_CONTEXT, attachment);
            } else {
                path.target().values().remove(DRAFT_READONLY_CONTEXT);
            }
        };
        CdsDataProcessor.create().addValidator(ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, validator).process(data, (CdsStructuredType)target);
    }

    public static void restoreReadonlyFields(CdsData data) {
        CdsData readOnlyData = (CdsData)data.get((Object)DRAFT_READONLY_CONTEXT);
        if (Objects.nonNull(readOnlyData)) {
            data.put((Object)"contentId", readOnlyData.get((Object)"contentId"));
            data.put((Object)"status", readOnlyData.get((Object)"status"));
            data.put((Object)"scannedAt", readOnlyData.get((Object)"scannedAt"));
            data.remove((Object)DRAFT_READONLY_CONTEXT);
        }
    }

    private ReadonlyDataContextEnhancer() {
    }
}

