/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.modifyevents;

import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.transaction.ListenerProvider;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.AttachmentModificationResult;
import com.sap.cds.feature.attachments.service.model.service.CreateAttachmentInput;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAttachmentEvent
implements ModifyAttachmentEvent {
    private static final Logger logger = LoggerFactory.getLogger(CreateAttachmentEvent.class);
    private final AttachmentService attachmentService;
    private final ListenerProvider listenerProvider;

    public CreateAttachmentEvent(AttachmentService attachmentService, ListenerProvider listenerProvider) {
        this.attachmentService = Objects.requireNonNull(attachmentService, "attachmentService must not be null");
        this.listenerProvider = Objects.requireNonNull(listenerProvider, "listenerProvider must not be null");
    }

    @Override
    public InputStream processEvent(Path path, InputStream content, Attachments attachment, EventContext eventContext) {
        logger.debug("Calling attachment service with create event for entity {}", (Object)path.target().entity().getQualifiedName());
        Map values = path.target().values();
        Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKey(path.target().keys());
        Optional<String> mimeTypeOptional = CreateAttachmentEvent.getFieldValue("mimeType", values, attachment);
        Optional<String> fileNameOptional = CreateAttachmentEvent.getFieldValue("fileName", values, attachment);
        CreateAttachmentInput createEventInput = new CreateAttachmentInput(keys, path.target().entity(), fileNameOptional.orElse(null), mimeTypeOptional.orElse(null), content);
        AttachmentModificationResult result = this.attachmentService.createAttachment(createEventInput);
        ChangeSetListener createListener = this.listenerProvider.provideListener(result.contentId(), eventContext.getCdsRuntime());
        eventContext.getChangeSetContext().register(createListener);
        path.target().values().put("contentId", result.contentId());
        path.target().values().put("status", result.status());
        return result.isInternalStored() ? content : null;
    }

    private static Optional<String> getFieldValue(String fieldName, Map<String, Object> values, Attachments attachment) {
        Object annotationValue = values.get(fieldName);
        Object value = Objects.nonNull(annotationValue) ? annotationValue : attachment.get(fieldName);
        return Optional.ofNullable((String)value);
    }
}

