/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.modifyevents;

import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.MarkAsDeletedInput;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkAsDeletedAttachmentEvent
implements ModifyAttachmentEvent {
    private static final Logger logger = LoggerFactory.getLogger(MarkAsDeletedAttachmentEvent.class);
    private final AttachmentService attachmentService;

    public MarkAsDeletedAttachmentEvent(AttachmentService attachmentService) {
        this.attachmentService = Objects.requireNonNull(attachmentService, "attachmentService must not be null");
    }

    @Override
    public InputStream processEvent(Path path, InputStream content, Attachments attachment, EventContext eventContext) {
        String newContentId;
        String qualifiedName = eventContext.getTarget().getQualifiedName();
        logger.debug("Processing the event for calling attachment service with mark as delete event for entity {}", (Object)qualifiedName);
        if (Objects.nonNull(attachment.getContentId()) && !"DRAFT_PATCH".equals(eventContext.getEvent())) {
            logger.debug("Calling attachment service with mark as delete event for entity {}", (Object)qualifiedName);
            this.attachmentService.markAttachmentAsDeleted(new MarkAsDeletedInput(attachment.getContentId(), eventContext.getUserInfo()));
        } else {
            logger.debug("Do NOT call attachment service with mark as delete event for entity {} as no document id found in existing data and event is DRAFT_PATCH event", (Object)qualifiedName);
        }
        if (Objects.nonNull(path) && (Objects.nonNull(newContentId = (String)path.target().values().get("contentId")) && newContentId.equals(attachment.getContentId()) || !path.target().values().containsKey("contentId"))) {
            path.target().values().put("contentId", null);
            path.target().values().put("status", null);
            path.target().values().put("scannedAt", null);
        }
        return content;
    }
}

