/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.modifyevents;

import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.CreateAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.DoNothingAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.MarkAsDeletedAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.UpdateAttachmentEvent;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

public class ModifyAttachmentEventFactory {
    private final CreateAttachmentEvent createEvent;
    private final UpdateAttachmentEvent updateEvent;
    private final MarkAsDeletedAttachmentEvent deleteEvent;
    private final DoNothingAttachmentEvent doNothingEvent;

    public ModifyAttachmentEventFactory(CreateAttachmentEvent createEvent, UpdateAttachmentEvent updateEvent, MarkAsDeletedAttachmentEvent deleteEvent, DoNothingAttachmentEvent doNothingEvent) {
        this.createEvent = Objects.requireNonNull(createEvent, "createEvent must not be null");
        this.updateEvent = Objects.requireNonNull(updateEvent, "updateEvent must not be null");
        this.deleteEvent = Objects.requireNonNull(deleteEvent, "deleteEvent must not be null");
        this.doNothingEvent = Objects.requireNonNull(doNothingEvent, "doNothingEvent must not be null");
    }

    public ModifyAttachmentEvent getEvent(InputStream content, String contentId, Attachments attachment) {
        Optional<ModifyAttachmentEvent> event = contentId != null ? this.handleExistingContentId(content, contentId, attachment.getContentId()) : this.handleNonExistingContentId(content, attachment.getContentId());
        return event.orElse(this.doNothingEvent);
    }

    private Optional<ModifyAttachmentEvent> handleExistingContentId(InputStream content, String contentId, String existingContentId) {
        ModifyAttachmentEvent event = null;
        if (contentId.equals(existingContentId) && Objects.nonNull(content)) {
            event = this.updateEvent;
        }
        if (Objects.nonNull(existingContentId) && !contentId.equals(existingContentId) && Objects.isNull(content)) {
            event = this.deleteEvent;
        }
        if (Objects.nonNull(existingContentId) && !contentId.equals(existingContentId) && Objects.nonNull(content)) {
            event = this.updateEvent;
        }
        return Optional.ofNullable(event);
    }

    private Optional<ModifyAttachmentEvent> handleNonExistingContentId(Object content, Object existingContentId) {
        ModifyAttachmentEvent event = null;
        if (Objects.nonNull(existingContentId)) {
            event = Objects.nonNull(content) ? this.updateEvent : this.deleteEvent;
        } else if (Objects.nonNull(content)) {
            event = this.createEvent;
        }
        return Optional.ofNullable(event);
    }
}

