/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.modifyevents;

import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.CreateAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.MarkAsDeletedAttachmentEvent;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEvent;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.services.EventContext;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAttachmentEvent
implements ModifyAttachmentEvent {
    private static final Logger logger = LoggerFactory.getLogger(UpdateAttachmentEvent.class);
    private final CreateAttachmentEvent createEvent;
    private final MarkAsDeletedAttachmentEvent deleteEvent;

    public UpdateAttachmentEvent(CreateAttachmentEvent createEvent, MarkAsDeletedAttachmentEvent deleteEvent) {
        this.createEvent = Objects.requireNonNull(createEvent, "createEvent must not be null");
        this.deleteEvent = Objects.requireNonNull(deleteEvent, "deleteEvent must not be null");
    }

    @Override
    public InputStream processEvent(Path path, InputStream content, Attachments attachment, EventContext eventContext) {
        logger.debug("Processing UPDATE event by calling attachment service with create and delete event for entity {}", (Object)path.target().entity().getQualifiedName());
        this.deleteEvent.processEvent(path, content, attachment, eventContext);
        return this.createEvent.processEvent(path, content, attachment, eventContext);
    }
}

