/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.readhelper;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeforeReadItemsModifier
implements Modifier {
    private static final Logger logger = LoggerFactory.getLogger(BeforeReadItemsModifier.class);
    private static final String ROOT_ASSOCIATION = "";
    private final List<String> mediaAssociations;

    public BeforeReadItemsModifier(List<String> mediaAssociations) {
        this.mediaAssociations = mediaAssociations;
    }

    public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        ArrayList<CqnSelectListItem> newItems = new ArrayList<CqnSelectListItem>(items.stream().filter(item -> !item.isExpand()).toList());
        List<CqnSelectListItem> result = this.addContentIdItem(items);
        newItems.addAll(result);
        return newItems;
    }

    private List<CqnSelectListItem> addContentIdItem(List<CqnSelectListItem> list) {
        ArrayList<CqnSelectListItem> newItems = new ArrayList<CqnSelectListItem>();
        this.enhanceWithNewFieldForMediaAssociation(ROOT_ASSOCIATION, list, newItems);
        List<CqnSelectListItem> expandedItems = list.stream().filter(CqnSelectListItem::isExpand).toList();
        newItems.addAll(this.processExpandedEntities(expandedItems));
        return newItems;
    }

    private List<CqnSelectListItem> processExpandedEntities(List<CqnSelectListItem> expandedItems) {
        ArrayList<CqnSelectListItem> newItems = new ArrayList<CqnSelectListItem>();
        expandedItems.forEach(item -> {
            ArrayList<CqnSelectListItem> newItemsFromExpand = new ArrayList<CqnSelectListItem>(item.asExpand().items().stream().filter(i -> !i.isExpand()).toList());
            this.enhanceWithNewFieldForMediaAssociation(item.asExpand().displayName(), newItemsFromExpand, newItemsFromExpand);
            List<CqnSelectListItem> expandedSubItems = item.asExpand().items().stream().filter(CqnSelectListItem::isExpand).toList();
            List<CqnSelectListItem> result = this.processExpandedEntities(expandedSubItems);
            newItemsFromExpand.addAll(result);
            Expand copy = CQL.copy((CqnExpand)item.asExpand());
            copy.items(newItemsFromExpand);
            newItems.add((CqnSelectListItem)copy);
        });
        return newItems;
    }

    private void enhanceWithNewFieldForMediaAssociation(String association, List<CqnSelectListItem> list, List<CqnSelectListItem> listToEnhance) {
        if (this.isMediaAssociationAndNeedNewContentIdField(association, list)) {
            logger.debug("Adding document id and status code to select items");
            listToEnhance.add((CqnSelectListItem)CQL.get((String)"contentId"));
            listToEnhance.add((CqnSelectListItem)CQL.get((String)"status"));
        }
    }

    private boolean isMediaAssociationAndNeedNewContentIdField(String association, List<CqnSelectListItem> list) {
        return this.mediaAssociations.contains(association) && list.stream().anyMatch(item -> this.isItemRefFieldWithName((CqnSelectListItem)item, "content")) && list.stream().noneMatch(item -> this.isItemRefFieldWithName((CqnSelectListItem)item, "contentId"));
    }

    private boolean isItemRefFieldWithName(CqnSelectListItem item, String fieldName) {
        return item.isRef() && item.asRef().displayName().equals(fieldName);
    }
}

