/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.applicationservice.transaction;

import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.model.service.MarkAsDeletedInput;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Objects;

public class CreationChangeSetListener
implements ChangeSetListener {
    private final String contentId;
    private final CdsRuntime cdsRuntime;
    private final AttachmentService attachmentService;

    public CreationChangeSetListener(String contentId, CdsRuntime cdsRuntime, AttachmentService attachmentService) {
        this.contentId = Objects.requireNonNull(contentId, "contentId must not be null");
        this.cdsRuntime = Objects.requireNonNull(cdsRuntime, "cdsRuntime must not be null");
        this.attachmentService = Objects.requireNonNull(attachmentService, "attachmentService must not be null");
    }

    public void afterClose(boolean completed) {
        if (!completed) {
            this.cdsRuntime.requestContext().run(requestContext -> this.attachmentService.markAttachmentAsDeleted(new MarkAsDeletedInput(this.contentId, requestContext.getUserInfo())));
        }
    }
}

