/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.common;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ApplicationHandlerHelper {
    private static final String ANNOTATION_IS_MEDIA_DATA = "_is_media_data";
    private static final String ANNOTATION_CORE_MEDIA_TYPE = "Core.MediaType";
    public static final CdsDataProcessor.Filter MEDIA_CONTENT_FILTER = (path, element, type) -> ApplicationHandlerHelper.isMediaEntity(path.target().type()) && element.findAnnotation(ANNOTATION_CORE_MEDIA_TYPE).isPresent();

    public static boolean containsContentField(CdsEntity entity, List<? extends CdsData> data) {
        AtomicBoolean isIncluded = new AtomicBoolean();
        CdsDataProcessor.create().addValidator(MEDIA_CONTENT_FILTER, (path, element, value) -> isIncluded.set(true)).process(data, (CdsStructuredType)entity);
        return isIncluded.get();
    }

    public static boolean isMediaEntity(CdsStructuredType baseEntity) {
        return (Boolean)baseEntity.getAnnotationValue(ANNOTATION_IS_MEDIA_DATA, (Object)false);
    }

    public static List<Attachments> condenseAttachments(List<? extends CdsData> data, CdsEntity entity) {
        ArrayList<Attachments> resultList = new ArrayList<Attachments>();
        CdsDataProcessor.Validator validator = (path, element, value) -> resultList.add(Attachments.of(path.target().values()));
        CdsDataProcessor.create().addValidator(MEDIA_CONTENT_FILTER, validator).process(data, (CdsStructuredType)entity);
        return resultList;
    }

    public static boolean areKeysInData(Map<String, Object> keys, CdsData data) {
        return keys.entrySet().stream().allMatch(entry -> {
            Object keyInData = data.get(entry.getKey());
            return Objects.nonNull(keyInData) && keyInData.equals(entry.getValue());
        });
    }

    public static Map<String, Object> removeDraftKey(Map<String, Object> keys) {
        HashMap<String, Object> keyMap = new HashMap<String, Object>(keys);
        keyMap.entrySet().removeIf(entry -> ((String)entry.getKey()).equals("IsActiveEntity"));
        return keyMap;
    }

    private ApplicationHandlerHelper() {
    }
}

