/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.draftservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.MarkAsDeletedAttachmentEvent;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.common.AttachmentsReader;
import com.sap.cds.feature.attachments.handler.draftservice.DraftUtils;
import com.sap.cds.feature.attachments.handler.draftservice.ModifierToCreateFlatCQN;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftCancelEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={DraftService.class})
public class DraftCancelAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DraftCancelAttachmentsHandler.class);
    private static final CdsDataProcessor.Filter contentIdFilter = (path, element, type) -> ApplicationHandlerHelper.isMediaEntity(path.target().type()) && element.getName().equals("contentId");
    private final AttachmentsReader attachmentsReader;
    private final MarkAsDeletedAttachmentEvent deleteEvent;

    public DraftCancelAttachmentsHandler(AttachmentsReader attachmentsReader, MarkAsDeletedAttachmentEvent deleteEvent) {
        this.attachmentsReader = Objects.requireNonNull(attachmentsReader, "attachmentsReader must not be null");
        this.deleteEvent = Objects.requireNonNull(deleteEvent, "deleteEvent must not be null");
    }

    @Before
    @HandlerOrder(value=10000)
    void processBeforeDraftCancel(DraftCancelEventContext context) {
        if ((this.isAttachmentEntity(context.getTarget()) || this.hasAttachmentAssociations(context.getTarget())) && this.isWhereEmpty(context)) {
            logger.debug("Processing before {} event for entity {}", (Object)context.getEvent(), (Object)context.getTarget());
            CdsEntity activeEntity = DraftUtils.getActiveEntity(context.getTarget());
            CdsEntity draftEntity = DraftUtils.getDraftEntity(context.getTarget());
            List<Attachments> draftAttachments = this.readAttachments(context, (CdsStructuredType)draftEntity, false);
            List<Attachments> activeCondensedAttachments = this.getCondensedActiveAttachments(context, (CdsStructuredType)activeEntity);
            CdsDataProcessor.Validator validator = this.buildDeleteContentValidator(context, activeCondensedAttachments);
            CdsDataProcessor.create().addValidator(contentIdFilter, validator).process(draftAttachments, (CdsStructuredType)context.getTarget());
        }
    }

    private CdsDataProcessor.Validator buildDeleteContentValidator(DraftCancelEventContext context, List<? extends CdsData> activeCondensedAttachments) {
        return (path, element, value) -> {
            Attachments attachment = Attachments.of(path.target().values());
            if (Boolean.FALSE.equals(attachment.get("HasActiveEntity"))) {
                this.deleteEvent.processEvent(path, null, attachment, (EventContext)context);
                return;
            }
            Map<String, Object> keys = ApplicationHandlerHelper.removeDraftKey(path.target().keys());
            Optional<CdsData> existingEntry = activeCondensedAttachments.stream().filter(updatedData -> ApplicationHandlerHelper.areKeysInData(keys, updatedData)).findAny();
            existingEntry.ifPresent(entry -> {
                if (!entry.get((Object)"contentId").equals(value)) {
                    this.deleteEvent.processEvent(null, null, attachment, (EventContext)context);
                }
            });
        };
    }

    private boolean isWhereEmpty(DraftCancelEventContext context) {
        return context.getCqn().where().isEmpty();
    }

    private boolean isAttachmentEntity(CdsEntity entity) {
        boolean hasAttachmentInName = entity.getQualifiedName().toLowerCase().contains("attachment");
        boolean hasFileNameElement = entity.elements().anyMatch(element -> "fileName".equals(element.getName()));
        logger.debug("Entity: {}, hasAttachmentInName: {}, hasFileNameElement: {}", new Object[]{entity.getQualifiedName(), hasAttachmentInName, hasFileNameElement});
        return hasAttachmentInName || hasFileNameElement;
    }

    private boolean hasAttachmentAssociations(CdsEntity entity) {
        return entity.elements().anyMatch(element -> element.getName().toLowerCase().contains("attachment"));
    }

    private List<Attachments> readAttachments(DraftCancelEventContext context, CdsStructuredType entity, boolean isActiveEntity) {
        logger.debug("Reading attachments for entity {} (isActiveEntity={})", (Object)entity.getName(), (Object)isActiveEntity);
        logger.debug("Original CQN: {}", (Object)context.getCqn());
        CqnDelete modifiedCQN = (CqnDelete)CQL.copy((CqnStatement)context.getCqn(), (Modifier)new ModifierToCreateFlatCQN(isActiveEntity, entity.getQualifiedName()));
        logger.debug("Modified CQN: {}", (Object)modifiedCQN);
        return this.attachmentsReader.readAttachments(context.getModel(), (CdsEntity)entity, (CqnFilterableStatement)modifiedCQN);
    }

    private List<Attachments> getCondensedActiveAttachments(DraftCancelEventContext context, CdsStructuredType activeEntity) {
        List<Attachments> attachments = this.readAttachments(context, activeEntity, true);
        return ApplicationHandlerHelper.condenseAttachments(attachments, context.getTarget());
    }
}

