/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.draftservice;

import com.sap.cds.CdsData;
import com.sap.cds.CdsDataProcessor;
import com.sap.cds.Result;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.handler.applicationservice.helper.ModifyApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.applicationservice.modifyevents.ModifyAttachmentEventFactory;
import com.sap.cds.feature.attachments.handler.common.ApplicationHandlerHelper;
import com.sap.cds.feature.attachments.handler.draftservice.DraftUtils;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.draft.DraftPatchEventContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.persistence.PersistenceService;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={DraftService.class})
public class DraftPatchAttachmentsHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DraftPatchAttachmentsHandler.class);
    private final PersistenceService persistence;
    private final ModifyAttachmentEventFactory eventFactory;

    public DraftPatchAttachmentsHandler(PersistenceService persistence, ModifyAttachmentEventFactory eventFactory) {
        this.persistence = Objects.requireNonNull(persistence, "persistence must not be null");
        this.eventFactory = Objects.requireNonNull(eventFactory, "eventFactory must not be null");
    }

    @Before
    @HandlerOrder(value=10000)
    void processBeforeDraftPatch(DraftPatchEventContext context, List<? extends CdsData> data) {
        logger.debug("Processing before {} event for entity {}", (Object)context.getEvent(), (Object)context.getTarget());
        CdsDataProcessor.Converter converter = (path, element, value) -> {
            CdsEntity draftEntity = DraftUtils.getDraftEntity(path.target().entity());
            Select select = Select.from((CdsEntity)draftEntity).matching(path.target().keys());
            Result result = this.persistence.run((CqnSelect)select, new Object[0]);
            return ModifyApplicationHandlerHelper.handleAttachmentForEntity(result.listOf(Attachments.class), this.eventFactory, (EventContext)context, path, (InputStream)value);
        };
        CdsDataProcessor.create().addConverter(ApplicationHandlerHelper.MEDIA_CONTENT_FILTER, converter).process(data, (CdsStructuredType)context.getTarget());
    }
}

