/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.handler.draftservice;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefBuilder;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifierToCreateFlatCQN
implements Modifier {
    private static final Logger logger = LoggerFactory.getLogger(ModifierToCreateFlatCQN.class);
    private final boolean isActiveEntity;
    private final String fullEntityName;

    ModifierToCreateFlatCQN(boolean isActiveEntity, String fullEntityName) {
        this.isActiveEntity = isActiveEntity;
        this.fullEntityName = fullEntityName;
    }

    public CqnStructuredTypeRef ref(CqnStructuredTypeRef original) {
        RefBuilder ref = CQL.copy((CqnStructuredTypeRef)original);
        RefBuilder.RefSegment rootSegment = ref.rootSegment();
        logger.debug("Modifying ref {} with isActiveEntity: {} and fullEntityName: {}", new Object[]{rootSegment, this.isActiveEntity, this.fullEntityName});
        CqnPredicate lastSegmentFilter = original.targetSegment().filter().orElse(null);
        Predicate isActiveEntityFilter = CQL.get((String)"IsActiveEntity").eq((Object)this.isActiveEntity);
        Predicate combinedFilter = lastSegmentFilter != null ? CQL.and((CqnPredicate)lastSegmentFilter, (CqnPredicate)isActiveEntityFilter) : isActiveEntityFilter;
        Predicate modifiedFilter = CQL.copy((CqnPredicate)combinedFilter, (Modifier)this);
        return CQL.entity((String)this.fullEntityName).filter((CqnPredicate)modifiedFilter).asRef();
    }

    public CqnPredicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
        Literal rhsNew = rhs;
        Literal lhsNew = lhs;
        if (lhs.isRef() && "IsActiveEntity".equals(lhs.asRef().lastSegment())) {
            rhsNew = CQL.constant((Object)this.isActiveEntity);
        }
        if (rhs.isRef() && "IsActiveEntity".equals(rhs.asRef().lastSegment())) {
            lhsNew = CQL.constant((Object)this.isActiveEntity);
        }
        return CQL.comparison(lhsNew, (CqnComparisonPredicate.Operator)op, rhsNew);
    }
}

