/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.handler;

import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.handler.transaction.EndTransactionMalwareScanProvider;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentCreateEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentMarkAsDeletedEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentReadEventContext;
import com.sap.cds.feature.attachments.service.model.servicehandler.AttachmentRestoreEventContext;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.HandlerOrder;
import com.sap.cds.services.handler.annotations.On;
import com.sap.cds.services.handler.annotations.ServiceName;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"*"}, type={AttachmentService.class})
public class DefaultAttachmentsServiceHandler
implements EventHandler {
    private static final int DEFAULT_ON = 11000;
    private static final Logger logger = LoggerFactory.getLogger(DefaultAttachmentsServiceHandler.class);
    private final EndTransactionMalwareScanProvider malwareScanProvider;

    public DefaultAttachmentsServiceHandler(EndTransactionMalwareScanProvider malwareScanProvider) {
        this.malwareScanProvider = Objects.requireNonNull(malwareScanProvider, "malwareScanProvider must not be null");
    }

    @On
    @HandlerOrder(value=11000)
    void createAttachment(AttachmentCreateEventContext context) {
        logger.debug("Default Attachment Service handler called for creating attachment for entity '{}'", (Object)context.getAttachmentEntity().getQualifiedName());
        String contentId = (String)context.getAttachmentIds().get("ID");
        context.getData().setStatus("Scanning");
        context.setIsInternalStored(true);
        context.setContentId(contentId);
        context.setCompleted();
    }

    @After
    void afterCreateAttachment(AttachmentCreateEventContext context) {
        ChangeSetListener listener = this.malwareScanProvider.getChangeSetListener(context.getAttachmentEntity(), context.getContentId());
        context.getChangeSetContext().register(listener);
    }

    @On
    @HandlerOrder(value=11000)
    void markAttachmentAsDeleted(AttachmentMarkAsDeletedEventContext context) {
        logger.debug("Default Attachment Service handler called for marking attachment as deleted with document id {}", (Object)context.getContentId());
        context.setCompleted();
    }

    @On
    @HandlerOrder(value=11000)
    void restoreAttachment(AttachmentRestoreEventContext context) {
        logger.debug("Default Attachment Service handler called for restoring attachment for timestamp {}", (Object)context.getRestoreTimestamp());
        context.setCompleted();
    }

    @On
    @HandlerOrder(value=11000)
    void readAttachment(AttachmentReadEventContext context) {
        logger.debug("Default Attachment Service handler called for reading attachment with document id {}", (Object)context.getContentId());
        context.setCompleted();
    }
}

