/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.handler.transaction;

import com.sap.cds.feature.attachments.service.malware.AsyncMalwareScanExecutor;
import com.sap.cds.feature.attachments.service.malware.AttachmentMalwareScanner;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.changeset.ChangeSetListener;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record EndTransactionMalwareScanRunner(CdsEntity attachmentEntity, String contentId, AttachmentMalwareScanner attachmentMalwareScanner, CdsRuntime runtime) implements ChangeSetListener,
AsyncMalwareScanExecutor
{
    private static final Logger logger = LoggerFactory.getLogger(EndTransactionMalwareScanRunner.class);

    public void afterClose(boolean completed) {
        if (completed) {
            this.startScanning(this.attachmentEntity, this.contentId);
        }
    }

    @Override
    public void scanAsync(CdsEntity attachmentEntity, String contentId) {
        this.startScanning(attachmentEntity, contentId);
    }

    private void startScanning(CdsEntity attachmentEntityToScan, String contentId) {
        RequestContextRunner runner = this.runtime.requestContext();
        logger.debug("Transaction completed. Starting to scan attachment {} in entity {} asynchronously.", (Object)contentId, (Object)attachmentEntityToScan.getQualifiedName());
        Supplier<Void> executeAdapterSupplier = () -> {
            runner.run(resourceCtx -> this.runtime.changeSetContext().run(changeSetCtx -> {
                logger.debug("Started asynchronously scan of attachment {} in entity {}.", (Object)contentId, (Object)attachmentEntityToScan.getQualifiedName());
                this.attachmentMalwareScanner.scanAttachment(attachmentEntityToScan, contentId);
            }));
            return null;
        };
        CompletableFuture.supplyAsync(executeAdapterSupplier).whenComplete((result, exception) -> {
            if (Objects.nonNull(exception)) {
                logger.error("Error scanning attachment {} in entity {}.", new Object[]{contentId, attachmentEntityToScan.getQualifiedName(), exception});
            } else {
                logger.debug("Scanning of attachment {} in entity {} was completed successfully.", (Object)contentId, (Object)attachmentEntityToScan.getQualifiedName());
            }
        });
    }
}

