/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.malware;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.Result;
import com.sap.cds.feature.attachments.generated.cds4j.sap.attachments.Attachments;
import com.sap.cds.feature.attachments.service.AttachmentService;
import com.sap.cds.feature.attachments.service.malware.AttachmentMalwareScanner;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanResultStatus;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.reflect.CdsElementNotFoundException;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.services.persistence.PersistenceService;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttachmentMalwareScanner
implements AttachmentMalwareScanner {
    public static final String MALWARE_SCAN_SERVICE_LABEL = "malware-scanner";
    private static final Logger logger = LoggerFactory.getLogger(DefaultAttachmentMalwareScanner.class);
    private final PersistenceService persistenceService;
    private final AttachmentService attachmentService;
    private final MalwareScanClient malwareScanClient;

    public DefaultAttachmentMalwareScanner(PersistenceService persistenceService, AttachmentService attachmentService, MalwareScanClient malwareScanClient) {
        this.persistenceService = Objects.requireNonNull(persistenceService, "persistenceService must not be null");
        this.attachmentService = Objects.requireNonNull(attachmentService, "attachmentService must not be null");
        this.malwareScanClient = malwareScanClient;
    }

    @Override
    public void scanAttachment(CdsEntity attachmentEntity, String contentId) {
        logger.debug("Started scanning attachment {} of entity {}.", (Object)contentId, (Object)attachmentEntity.getQualifiedName());
        List<SelectionResult> selectionResult = this.selectData(attachmentEntity, contentId);
        selectionResult.forEach(result -> {
            long rowCount = result.result().rowCount();
            if (rowCount <= 0L) {
                logger.debug("No attachments {} found in entity {}, nothing to scan.", (Object)contentId, (Object)result.entity.getQualifiedName());
                return;
            }
            if (rowCount > 1L) {
                logger.warn("More than one attachment {} found in entity {}.", (Object)contentId, (Object)result.entity.getQualifiedName());
                throw new IllegalStateException("More than one attachment with contentId %s.".formatted(contentId));
            }
            Attachments attachment = (Attachments)result.result().single(Attachments.class);
            MalwareScanResultStatus status = this.scanDocument(attachment);
            this.updateData(result.entity, contentId, status);
        });
    }

    private List<SelectionResult> selectData(CdsEntity attachmentEntity, String contentId) {
        ArrayList<SelectionResult> result = new ArrayList<SelectionResult>();
        try {
            CdsEntity entity = (CdsEntity)attachmentEntity.getTargetOf("SiblingEntity");
            Result selectionResult = this.readData(contentId, entity);
            result.add(new SelectionResult(entity, selectionResult));
        }
        catch (CdsElementNotFoundException entity) {
            // empty catch block
        }
        Result selectionResult = this.readData(contentId, attachmentEntity);
        result.add(new SelectionResult(attachmentEntity, selectionResult));
        return result;
    }

    private Result readData(String contentId, CdsEntity entity) {
        Select select = Select.from((CdsEntity)entity).columns(new String[]{"contentId", "content", "status"}).where(e -> e.get("contentId").eq((Object)contentId).and((CqnPredicate)e.get("status").ne((Object)"Clean"), new CqnPredicate[0]));
        Result result = this.persistenceService.run((CqnSelect)select, new Object[0]);
        result.streamOf(Attachments.class).forEach(attachment -> logger.debug("Found attachment {} in entity {} with status {}.", new Object[]{attachment.getContentId(), entity.getQualifiedName(), attachment.getStatus()}));
        return result;
    }

    private MalwareScanResultStatus scanDocument(Attachments attachment) {
        if (this.malwareScanClient != null) {
            try {
                InputStream content = Objects.nonNull(attachment.getContent()) ? attachment.getContent() : this.attachmentService.readAttachment(attachment.getContentId());
                logger.debug("Start scanning attachment {}.", (Object)attachment.getContentId());
                return this.malwareScanClient.scanContent(content);
            }
            catch (RuntimeException e) {
                logger.error("Error while scanning attachment {}.", (Object)attachment.getContentId(), (Object)e);
                return MalwareScanResultStatus.FAILED;
            }
        }
        return MalwareScanResultStatus.NO_SCANNER;
    }

    private void updateData(CdsEntity attachmentEntity, String contentId, MalwareScanResultStatus status) {
        Attachments updateData = Attachments.create();
        updateData.setStatus(DefaultAttachmentMalwareScanner.mapStatus(status));
        updateData.setScannedAt(Instant.now());
        Update update = Update.entity((CdsEntity)attachmentEntity).data((Map)((Object)updateData)).where(entry -> entry.get("contentId").eq((Object)contentId));
        Result result = this.persistenceService.run((CqnUpdate)update, new Object[0]);
        logger.debug("Updated scan status to {} of attachment {} in entity {} -> Row count {}.", new Object[]{updateData.getStatus(), contentId, attachmentEntity.getQualifiedName(), result.rowCount()});
    }

    @VisibleForTesting
    static String mapStatus(MalwareScanResultStatus status) {
        return switch (status) {
            case MalwareScanResultStatus.CLEAN, MalwareScanResultStatus.NO_SCANNER -> "Clean";
            case MalwareScanResultStatus.INFECTED, MalwareScanResultStatus.ENCRYPTED -> "Infected";
            default -> "Failed";
        };
    }

    private record SelectionResult(CdsEntity entity, Result result) {
    }
}

