/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.malware.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.attachments.service.malware.client.HttpClientProvider;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanClient;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanResult;
import com.sap.cds.feature.attachments.service.malware.client.MalwareScanResultStatus;
import com.sap.cds.services.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMalwareScanClient
implements MalwareScanClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMalwareScanClient.class);
    private static final String JSON_CONTENT = "application/json";
    private final ObjectMapper mapper = DefaultMalwareScanClient.buildObjectMapper();
    private final HttpClientProvider clientProvider;

    public DefaultMalwareScanClient(HttpClientProvider clientProvider) {
        this.clientProvider = Objects.requireNonNull(clientProvider, "clientProvider must not be null");
    }

    @Override
    public MalwareScanResultStatus scanContent(InputStream content) {
        HttpPost request = DefaultMalwareScanClient.buildHttpRequest(content);
        return this.executeRequest(request);
    }

    private MalwareScanResultStatus executeRequest(HttpPost request) {
        MalwareScanResultStatus malwareScanResultStatus;
        block8: {
            HttpClient httpClient = this.clientProvider.getHttpClient();
            CloseableHttpResponse response = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)request);
            try {
                MalwareScanResult malwareScanResult = this.convertHttpResponseToJavaObject(response);
                malwareScanResultStatus = DefaultMalwareScanClient.mapResponseToStatus(malwareScanResult);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
            response.close();
        }
        return malwareScanResultStatus;
    }

    private MalwareScanResult convertHttpResponseToJavaObject(CloseableHttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        logger.debug("Server responded with status code '{}'", (Object)code);
        if (code >= 200 && code <= 207) {
            String contentType = JSON_CONTENT;
            if (response.getEntity() != null) {
                if (Objects.nonNull(response.getEntity().getContentType())) {
                    contentType = response.getEntity().getContentType().getValue();
                }
                if (contentType.contains(JSON_CONTENT)) {
                    String jsonData = EntityUtils.toString((HttpEntity)response.getEntity());
                    return (MalwareScanResult)this.mapper.readValue(jsonData, MalwareScanResult.class);
                }
                throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
            }
            return (MalwareScanResult)this.mapper.readValue("{}", MalwareScanResult.class);
        }
        String reason = response.getStatusLine().getReasonPhrase();
        throw new IOException("Unexpected request HTTP response (" + code + ") " + reason);
    }

    private static MalwareScanResultStatus mapResponseToStatus(MalwareScanResult scanResult) {
        if (scanResult.isMalwareDetected() || scanResult.isEncryptedContentDetected()) {
            logger.warn("Document is infected with malware, response status from scan was: malwareDetected = {}, encryptedContentDetected = {}", (Object)scanResult.isMalwareDetected(), (Object)scanResult.isEncryptedContentDetected());
            return MalwareScanResultStatus.INFECTED;
        }
        return MalwareScanResultStatus.CLEAN;
    }

    private static HttpPost buildHttpRequest(InputStream content) {
        InputStreamEntity reqEntity = new InputStreamEntity(content, -1L);
        reqEntity.setContentType("binary/octet-stream");
        reqEntity.setChunked(true);
        HttpPost request = new HttpPost();
        request.setEntity((HttpEntity)reqEntity);
        return request;
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }
}

