/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.attachments.service.malware.client;

import com.sap.cds.feature.attachments.service.malware.client.HttpClientProvider;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.HttpClient;

public final class MalwareScanClientProvider
implements HttpClientProvider {
    private final HttpClient httpClient;

    public MalwareScanClientProvider(ServiceBinding binding, CdsProperties.ConnectionPool configuration) {
        Map credentials = binding.getCredentials();
        BasicCredentials basic = new BasicCredentials((String)credentials.get("username"), (String)credentials.get("password"));
        String url = (String)credentials.get("url");
        URI serviceUrl = URI.create(url + "/scan").normalize();
        DefaultHttpDestination destination = DefaultHttpDestination.builder((URI)serviceUrl).name("malware-scanner").basicCredentials(basic).build();
        DefaultHttpClientFactory.DefaultHttpClientFactoryBuilder builder = DefaultHttpClientFactory.builder();
        builder.timeoutMilliseconds((int)configuration.getTimeout().toMillis());
        builder.maxConnectionsPerRoute(configuration.getMaxConnectionsPerRoute().intValue());
        builder.maxConnectionsTotal(configuration.getMaxConnections().intValue());
        DefaultHttpClientFactory factory = builder.build();
        this.httpClient = factory.createHttpClient((HttpDestinationProperties)destination);
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

