/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.auditlog.v2;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.feature.auditlog.v2.AuditLogV2Handler;
import com.sap.cds.feature.auditlog.v2.AuditLogV2MtHandler;
import com.sap.cds.feature.auditlog.v2.AuditLogV2Utils;
import com.sap.cds.feature.auditlog.v2.CloudSdkCommunicator;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditLogMessageFactoryImpl;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogV2Configuration
implements CdsRuntimeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogV2Configuration.class);
    static final String AUDITLOG = "auditlog";

    public void eventHandlers(CdsRuntimeConfigurer configurer) {
        CdsRuntime runtime = configurer.getCdsRuntime();
        if (runtime.getEnvironment().getCdsProperties().getAuditLog().getV2().isEnabled().booleanValue()) {
            ServiceBinding binding = runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)AUDITLOG)).findFirst().orElse(null);
            if (binding != null) {
                LOGGER.info("Using Auditlog v2 service binding with name '{}' and plan '{}' to register Auditlog v2 event handler.", binding.getName().get(), binding.getServicePlan().get());
                AuditLogV2Handler handler = this.createHandler(binding, configurer);
                configurer.eventHandler((Object)handler);
            } else {
                LOGGER.info("No Auditlog v2 service binding found, v2 handler not registered.");
            }
        } else {
            LOGGER.info("AuditLog v2 is disabled, v2 handler not registered.");
        }
    }

    @VisibleForTesting
    AuditLogV2Handler createHandler(ServiceBinding binding, CdsRuntimeConfigurer configurer) {
        boolean oAuth2;
        if (AuditLogV2Utils.isOAuth2BasedServicePlan(binding)) {
            oAuth2 = true;
            if (AuditLogV2Configuration.isMtEnabled(configurer)) {
                LOGGER.debug("Registering event handler to provide auditlog OAuth2 service binding '{}' as multitenancy dependency.", binding.getName().orElse(null));
                configurer.eventHandler((Object)new AuditLogV2MtHandler(binding));
            }
        } else if (AuditLogV2Utils.isStandardPlan(binding)) {
            oAuth2 = false;
        } else {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.AUDITLOG_SERVICE_INVALID_PLAN, new Object[]{binding.getServicePlan().orElse(null)});
        }
        CloudSdkCommunicator communicator = new CloudSdkCommunicator(binding, configurer.getCdsRuntime());
        AuditLogMessageFactoryImpl factory = new AuditLogMessageFactoryImpl(communicator);
        TenantProviderService tenantService = (TenantProviderService)configurer.getCdsRuntime().getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
        return new AuditLogV2Handler(factory, oAuth2, tenantService, communicator.getClientId());
    }

    private static boolean isMtEnabled(CdsRuntimeConfigurer configurer) {
        ServiceCatalog catalog = configurer.getCdsRuntime().getServiceCatalog();
        return catalog.getServices(DeploymentService.class).count() > 0L;
    }
}

