/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.auditlog.v2;

import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.After;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.mt.DependenciesEventContext;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"DeploymentService$Default"})
class AuditLogV2MtHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogV2MtHandler.class);
    private final ServiceBinding binding;

    AuditLogV2MtHandler(ServiceBinding binding) {
        this.binding = Objects.requireNonNull(binding, "binding must not be null");
    }

    @After
    public void addAuditLogV2Dependency(DependenciesEventContext context) {
        String xsappname;
        Map uaa = (Map)this.binding.getCredentials().get("uaa");
        String string = xsappname = uaa != null ? (String)uaa.get("xsappname") : null;
        if (xsappname != null) {
            logger.debug("Providing AuditLog v2 service binding dependency '{}' to xsappname '{}'", (Object)this.binding.getName().orElse(""), (Object)xsappname);
            context.getResult().add(Collections.singletonMap("xsappname", xsappname));
        } else {
            logger.warn("xsappname missing in service binding: '{}'", (Object)this.binding.getName().orElse(""));
        }
    }
}

