/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.AuditLogMessageFactory;
import com.sap.cds.repackaged.audit.api.ConfigurationChangeAuditMessage;
import com.sap.cds.repackaged.audit.api.DataAccessAuditMessage;
import com.sap.cds.repackaged.audit.api.DataModificationAuditMessage;
import com.sap.cds.repackaged.audit.api.SecurityEventAuditMessage;
import com.sap.cds.repackaged.audit.api.exception.AuditLogException;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.ConfigurationChangeMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.ConsoleCommunicator;
import com.sap.cds.repackaged.audit.client.impl.DataAccessMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.DataModificationMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.HttpCommunicator;
import com.sap.cds.repackaged.audit.client.impl.SecurityEventMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditLogMessageFactoryImplBase;
import com.sap.xs.env.Credentials;
import com.sap.xs.env.VcapServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageFactoryImpl
extends AuditLogMessageFactoryImplBase
implements AuditLogMessageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"/System/AuditLog");
    static final String AUDIT_SERVICE_URL_PATH_STANDARD_PLAN = "/audit-log/v1/";
    static final String AUDIT_SERVICE_URL_PATH_OAUTH2_PLAN = "/audit-log/oauth2/v1/";
    private Communicator communicator = null;

    public AuditLogMessageFactoryImpl() throws AuditLogException {
        this(null);
    }

    public AuditLogMessageFactoryImpl(VcapServices vcapServices) throws AuditLogException {
        Credentials credentials = this.getCredentials(vcapServices, null);
        if (credentials == null) {
            this.communicator = new ConsoleCommunicator();
        } else {
            String plan = this.getServicePlan(vcapServices, null);
            String urlFromCredentials = credentials.getUrl();
            String auditlogServiceUrl = plan.equals("oauth2") ? urlFromCredentials + AUDIT_SERVICE_URL_PATH_OAUTH2_PLAN : urlFromCredentials + AUDIT_SERVICE_URL_PATH_STANDARD_PLAN;
            this.communicator = new HttpCommunicator(credentials, plan, auditlogServiceUrl);
        }
    }

    public AuditLogMessageFactoryImpl(String serviceUrl, String serviceUser, String servicePassword) {
        if (serviceUrl == null || serviceUser == null || servicePassword == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        Credentials credentials = new Credentials();
        credentials.setUser(serviceUser);
        credentials.setPassword(servicePassword);
        credentials.setUrl(serviceUrl);
        this.communicator = new HttpCommunicator(credentials, "standard", serviceUrl);
    }

    public AuditLogMessageFactoryImpl(String serviceUrl, String xsuaaClientId, String xsuaaSecret, String xsuaaUrl) {
        if (serviceUrl == null || xsuaaClientId == null || xsuaaSecret == null || xsuaaUrl == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        Credentials credentials = new Credentials();
        credentials.set("uaa", this.assembleUaaObject(xsuaaClientId, xsuaaSecret, xsuaaUrl));
        credentials.setUrl(serviceUrl);
        this.communicator = new HttpCommunicator(credentials, "oauth2", serviceUrl);
    }

    public AuditLogMessageFactoryImpl(String serviceUrl, String xsuaaClientId, String xsuaaCertUrl, byte[] certificate, byte[] key) {
        if (serviceUrl == null || xsuaaClientId == null || certificate == null || key == null || xsuaaCertUrl == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        Credentials credentials = new Credentials();
        credentials.set("uaa", this.assembleUaaObject(xsuaaClientId, xsuaaCertUrl, certificate, key));
        credentials.setUrl(serviceUrl);
        this.communicator = new HttpCommunicator(credentials, "oauth2", serviceUrl);
    }

    String getServiceUrl() {
        return this.communicator.getServiceUrl();
    }

    Communicator getCommunicator() {
        return this.communicator;
    }

    void setCommunicator(Communicator httpCommunicator) {
        this.communicator = httpCommunicator;
    }

    @Override
    public DataAccessAuditMessage createDataAccessAuditMessage() {
        return new DataAccessMessageImpl(this);
    }

    @Override
    public DataModificationAuditMessage createDataModificationAuditMessage() {
        return new DataModificationMessageImpl(this);
    }

    @Override
    public ConfigurationChangeAuditMessage createConfigurationChangeAuditMessage() {
        return new ConfigurationChangeMessageImpl(this);
    }

    @Override
    public SecurityEventAuditMessage createSecurityEventAuditMessage() {
        return new SecurityEventMessageImpl(this);
    }
}

