/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.repackaged.audit.api.exception.ClientInitializationException;
import com.sap.cds.repackaged.audit.client.impl.OAuthCredentials;
import com.sap.xs.env.Credentials;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCredentialParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCredentialParser.class);
    private static final String UAA_PARAMETER_NAME = "uaa";
    private static final String NO_UAA_PARAMETER_DETECTED = "No \"uaa\" parameter detected in the service configuration, this should be the standard plan scenario";
    private static final String PARSING_CREDENTIALS_ERROR = "Problem occurred while trying to parse XSUAA credentials";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Credentials serviceCredentials;

    public ServiceCredentialParser(Credentials serviceCredentials) {
        this.serviceCredentials = serviceCredentials;
    }

    public OAuthCredentials parseCredentials() {
        Object uaaObj = this.serviceCredentials.any().get(UAA_PARAMETER_NAME);
        if (uaaObj == null) {
            LOGGER.info(NO_UAA_PARAMETER_DETECTED);
            return null;
        }
        try {
            String jsonInString = MAPPER.writeValueAsString(uaaObj);
            OAuthCredentials oauthCredentials = (OAuthCredentials)MAPPER.readValue(jsonInString, OAuthCredentials.class);
            return oauthCredentials;
        }
        catch (IOException e) {
            throw new ClientInitializationException(PARSING_CREDENTIALS_ERROR, e);
        }
    }
}

