/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.TransactionalAuditLogMessage;
import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.client.impl.AuditLogIdentifier;
import com.sap.cds.repackaged.audit.client.impl.AuditLogMessageFactoryImpl;
import com.sap.cds.repackaged.audit.client.impl.AuditLogMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.Utils;
import com.sap.xs.audit.message.ConfigurationChange;
import com.sap.xs.audit.message.DataModification;
import com.sap.xs.audit.message.TransactionalMessage;
import com.sap.xs.audit.message.TransactionalStatusMessage;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.JsonParserUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;

public class TransactionalLogImpl<T extends TransactionalMessage>
extends AuditLogMessageImpl<T>
implements TransactionalAuditLogMessage {
    public TransactionalLogImpl(AuditLogMessageFactoryImpl factory) {
        super(factory);
    }

    public TransactionalLogImpl(Communicator communicator) {
        super(communicator);
    }

    @Override
    public void logPrepare() throws AuditLogNotAvailableException, AuditLogWriteException {
        if (this.alreadyLogged) {
            LOGGER.warn("Audit message ignored as it has already been persisted successfully.");
            return;
        }
        if (((TransactionalMessage)this.message).getUser() == null || "$USER".equals(((TransactionalMessage)this.message).getUser())) {
            String user = Utils.getUser();
            ((TransactionalMessage)this.message).setUser(user != null ? user : this.communicator.getClientId());
        }
        if (this.eventTime == null) {
            this.eventTime = Instant.now();
        }
        ((TransactionalMessage)this.message).setTime(this.eventTime);
        ((TransactionalMessage)this.message).setStatus("BEGIN");
        try {
            ((TransactionalMessage)this.message).validate();
        }
        catch (ValidationError e) {
            LOGGER.error("Audit log message cannot be validated.");
            throw new AuditLogWriteException("Audit log message cannot be validated.", ((TransactionalMessage)this.message).getErrors());
        }
        try {
            String resp = this.communicator.send(this.serializeMessage(), this.endpoint, ((TransactionalMessage)this.message).getSubscriberTokenIssuer());
            AuditLogIdentifier auditLogIdentifier = JsonParserUtils.desrializeMessage(resp, AuditLogIdentifier.class);
            ((TransactionalMessage)this.message).setId(auditLogIdentifier.getId());
            this.alreadyPrepared = true;
        }
        catch (IOException e) {
            throw new AuditLogWriteException("Audit server returned invalid response.", e);
        }
    }

    @Override
    public void logSuccess() throws AuditLogNotAvailableException, AuditLogWriteException {
        this.logStatus(true);
    }

    @Override
    public void logFailure() throws AuditLogNotAvailableException, AuditLogWriteException {
        this.logStatus(false);
    }

    private void logStatus(boolean success) throws AuditLogNotAvailableException, AuditLogWriteException {
        if (this.alreadyLogged) {
            LOGGER.warn("Audit message ignored as it has already been persisted successfully.");
            return;
        }
        ((TransactionalMessage)this.message).setUuid(UUID.randomUUID().toString());
        if (((TransactionalMessage)this.message).getUser() == null || "$USER".equals(((TransactionalMessage)this.message).getUser())) {
            String user = Utils.getUser();
            ((TransactionalMessage)this.message).setUser(user != null ? user : this.communicator.getClientId());
        }
        if (this.eventTime == null) {
            this.eventTime = Instant.now();
        }
        ((TransactionalMessage)this.message).setTime(this.eventTime);
        try {
            ((TransactionalMessage)this.message).validate();
        }
        catch (ValidationError e) {
            throw new AuditLogWriteException("Audit log message cannot be validated.", ((TransactionalMessage)this.message).getErrors());
        }
        ((TransactionalMessage)this.message).setSuccess(success);
        ((TransactionalMessage)this.message).setStatus("END");
        if (this.communicator.getServiceUrl().endsWith("/audit-log/v1/") || this.communicator.getServiceUrl().endsWith("/audit-log/oauth2/v1/")) {
            if (((TransactionalMessage)this.message).getId() == null) {
                this.communicator.send(this.serializeMessage(), this.endpoint, ((TransactionalMessage)this.message).getSubscriberTokenIssuer());
            } else {
                TransactionalStatusMessage transStatusMsg = new TransactionalStatusMessage();
                try {
                    String id = URLEncoder.encode(((TransactionalMessage)this.message).getId(), StandardCharsets.ISO_8859_1.toString());
                    transStatusMsg.setSuccess(success);
                    transStatusMsg.setTenant(((TransactionalMessage)this.message).getTenant());
                    transStatusMsg.setUuid(((TransactionalMessage)this.message).getUuid());
                    transStatusMsg.validate();
                    String endpoint = "";
                    if (this.message instanceof ConfigurationChange) {
                        endpoint = "configuration-changes/";
                    } else if (this.message instanceof DataModification) {
                        endpoint = "data-modifications/";
                    }
                    this.communicator.send(this.serializeMessage(transStatusMsg), this.communicator.getServiceUrl() + endpoint + id, ((TransactionalMessage)this.message).getSubscriberTokenIssuer());
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("The Character Encoding is not supported.");
                }
                catch (ValidationError e) {
                    throw new AuditLogWriteException("Audit log status message cannot be validated.", transStatusMsg.getErrors());
                }
            }
        } else {
            this.communicator.send(this.serializeMessage(), this.endpoint, ((TransactionalMessage)this.message).getSubscriberTokenIssuer());
        }
        this.alreadyLogged = true;
    }
}

