/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl.v2;

import com.sap.cds.repackaged.audit.api.exception.AuditLogException;
import com.sap.cds.repackaged.audit.api.v2.AuditLogMessageFactory;
import com.sap.cds.repackaged.audit.api.v2.AuditedDataSubject;
import com.sap.cds.repackaged.audit.api.v2.AuditedObject;
import com.sap.cds.repackaged.audit.api.v2.ConfigurationChangeAuditMessage;
import com.sap.cds.repackaged.audit.api.v2.DataAccessAuditMessage;
import com.sap.cds.repackaged.audit.api.v2.DataModificationAuditMessage;
import com.sap.cds.repackaged.audit.api.v2.SecurityEventAuditMessage;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.ConsoleCommunicator;
import com.sap.cds.repackaged.audit.client.impl.HttpCommunicator;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditLogMessageFactoryImplBase;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditedDataSubjectImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditedObjectImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.ConfigurationChangeMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.DataAccessMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.DataModificationMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.SecurityEventMessageImpl;
import com.sap.xs.env.Credentials;
import com.sap.xs.env.VcapServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageFactoryImpl
extends AuditLogMessageFactoryImplBase
implements AuditLogMessageFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"/System/AuditLog");
    static final String AUDIT_SERVICE_URL_PATH_STANDARD_PLAN = "/audit-log/v2/";
    static final String AUDIT_SERVICE_URL_PATH_OAUTH2_PLAN = "/audit-log/oauth2/v2/";
    private Communicator communicator = null;

    public AuditLogMessageFactoryImpl() throws AuditLogException {
        this(null, null);
    }

    public AuditLogMessageFactoryImpl(String bindingName) throws AuditLogException {
        this(null, bindingName);
    }

    public AuditLogMessageFactoryImpl(VcapServices vcapServices) throws AuditLogException {
        this(vcapServices, null);
    }

    public AuditLogMessageFactoryImpl(VcapServices vcapServices, String bindingName) throws AuditLogException {
        Credentials credentials = this.getCredentials(vcapServices, bindingName);
        if (credentials == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        String plan = this.getServicePlan(vcapServices, bindingName);
        String urlFromCredentials = credentials.getUrl();
        String auditlogServiceUrl = plan.equals("oauth2") ? urlFromCredentials + AUDIT_SERVICE_URL_PATH_OAUTH2_PLAN : urlFromCredentials + AUDIT_SERVICE_URL_PATH_STANDARD_PLAN;
        this.communicator = new HttpCommunicator(credentials, plan, auditlogServiceUrl);
    }

    public AuditLogMessageFactoryImpl(String serviceUrl, String serviceUser, String servicePassword) {
        if (serviceUrl == null || serviceUser == null || servicePassword == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        Credentials credentials = new Credentials();
        credentials.setUser(serviceUser);
        credentials.setPassword(servicePassword);
        credentials.setUrl(serviceUrl);
        this.communicator = new HttpCommunicator(credentials, "standard", serviceUrl);
    }

    public AuditLogMessageFactoryImpl(String serviceUrl, String xsuaaClientId, String xsuaaSecret, String xsuaaUrl) {
        if (serviceUrl == null || xsuaaClientId == null || xsuaaSecret == null || xsuaaUrl == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        Credentials credentials = new Credentials();
        credentials.set("uaa", this.assembleUaaObject(xsuaaClientId, xsuaaSecret, xsuaaUrl));
        credentials.setUrl(serviceUrl);
        this.communicator = new HttpCommunicator(credentials, "oauth2", serviceUrl);
    }

    public AuditLogMessageFactoryImpl(String serviceUrl, String xsuaaClientId, String xsuaaCertUrl, byte[] certificate, byte[] key) {
        if (serviceUrl == null || xsuaaClientId == null || certificate == null || key == null || xsuaaCertUrl == null) {
            LOGGER.error("Missing audit log service credentials parameters. Cannot send audit log message to the backend.");
            this.communicator = new ConsoleCommunicator();
            return;
        }
        Credentials credentials = new Credentials();
        credentials.set("uaa", this.assembleUaaObject(xsuaaClientId, xsuaaCertUrl, certificate, key));
        credentials.setUrl(serviceUrl);
        this.communicator = new HttpCommunicator(credentials, "oauth2", serviceUrl);
    }

    public AuditLogMessageFactoryImpl(Communicator customCommunicator) {
        if (customCommunicator == null) {
            this.communicator = new ConsoleCommunicator();
            return;
        }
        this.communicator = customCommunicator;
    }

    void setCommunicator(Communicator httpCommunicator) {
        this.communicator = httpCommunicator;
    }

    Communicator getCommunicator() {
        return this.communicator;
    }

    @Override
    public DataAccessAuditMessage createDataAccessAuditMessage() {
        return new DataAccessMessageImpl(this.communicator);
    }

    @Override
    public DataModificationAuditMessage createDataModificationAuditMessage() {
        return new DataModificationMessageImpl(this.communicator);
    }

    @Override
    public ConfigurationChangeAuditMessage createConfigurationChangeAuditMessage() {
        return new ConfigurationChangeMessageImpl(this.communicator);
    }

    @Override
    public SecurityEventAuditMessage createSecurityEventAuditMessage() {
        return new SecurityEventMessageImpl(this.communicator);
    }

    @Override
    public AuditedObject createAuditedObject() {
        return new AuditedObjectImpl();
    }

    @Override
    public AuditedDataSubject createAuditedDataSubject() {
        return new AuditedDataSubjectImpl();
    }
}

