/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.client.impl.OAuthCredentials;
import com.sap.xs.env.Credentials;
import com.sap.xs.env.Service;
import com.sap.xs.env.VcapServices;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogMessageFactoryImplBase {
    private static final String CERTIFICATE_KEY_MAP_FIELD = "key";
    private static final String CERTIFICATE_KEY = "certificate";
    private static final String CREDENTIAL_TYPE_KEY = "credential-type";
    private static final String CERT_URL_KEY = "certurl";
    private static final String XSUAA_DOMAIN_KEY = "uaadomain";
    private static final String URL_KEY = "url";
    private static final String CLIENT_SECRET_KEY = "clientsecret";
    private static final String CLIENT_ID_KEY = "clientid";
    private static final String DOT_REGEX = "\\.";
    private static final String CANNOT_GET_PLAN_OF_AUDITLOG_SERVICE_ERROR_MESSAGE = "Cannot get plan of auditlog service";
    private static final String UNABLE_TO_GET_XSUAA_DOMAIN_ERROR_MESSAGE = "Could not extract domain from given XSUAA Certificate URL. Please pass a correct URL.";
    private static final String NO_BINDING_WITH_GIVEN_NAME = "There is no service binding with this exact name : ";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"/System/AuditLog");
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String PARSING_CREDENTIALS_ERROR = "Problem occurred while trying to parse XSUAA credentials";
    static final String AUDIT_LOG_SERVICE_NAME = "auditlog";
    private static final String BINDING_NAME_ATTRIBUTE = "binding_name";
    private static final String CERT_REGEX = "\\.cert\\.";

    protected LinkedHashMap<String, String> assembleUaaObject(String xsuaaClientId, String xsuaaSecret, String xsuaaUrl) {
        LinkedHashMap<String, String> uaaObject = new LinkedHashMap<String, String>();
        uaaObject.put(CLIENT_ID_KEY, xsuaaClientId);
        uaaObject.put(CLIENT_SECRET_KEY, xsuaaSecret);
        uaaObject.put(URL_KEY, xsuaaUrl);
        try {
            uaaObject.put(XSUAA_DOMAIN_KEY, this.getUaaDomainFromXsuaaUrl(xsuaaUrl));
        }
        catch (AuditLogWriteException e) {
            LOGGER.error(e.getMessage());
        }
        return uaaObject;
    }

    protected LinkedHashMap<String, String> assembleUaaObject(String xsuaaClientId, String xsuaaCertUrl, byte[] certificate, byte[] key) {
        LinkedHashMap<String, String> uaaObject = new LinkedHashMap<String, String>();
        uaaObject.put(CLIENT_ID_KEY, xsuaaClientId);
        uaaObject.put(CERT_URL_KEY, xsuaaCertUrl);
        uaaObject.put(CREDENTIAL_TYPE_KEY, "x509");
        uaaObject.put(CERTIFICATE_KEY, new String(certificate, StandardCharsets.UTF_8));
        uaaObject.put(CERTIFICATE_KEY_MAP_FIELD, new String(key, StandardCharsets.UTF_8));
        try {
            uaaObject.put(XSUAA_DOMAIN_KEY, this.getUaaDomainFromXsuaaCertUrl(xsuaaCertUrl));
        }
        catch (AuditLogWriteException e) {
            LOGGER.error(e.getMessage());
        }
        return uaaObject;
    }

    protected Credentials getCredentials(VcapServices vcapServices, String bindingName) throws AuditLogWriteException {
        Service auditService = this.getAuditService(vcapServices, bindingName);
        Credentials credentials = null;
        if (auditService == null || (credentials = auditService.getCredentials()) == null) {
            LOGGER.error("Cannot send audit log message to the backend: audit log service environment configuration is missing or incomplete.");
            return null;
        }
        String plan = auditService.getPlan();
        if (plan.equals("standard") && !this.areStandardCredentialsExisting(credentials)) {
            LOGGER.error("Cannot send audit log message to the backend: audit log service environment configuration is missing or incomplete.");
            return null;
        }
        if (plan.equals("oauth2") && !this.areXsuaaCredentialsExisting(credentials)) {
            LOGGER.error("Cannot send audit log message to the backend: audit log service environment configuration is missing or incomplete.");
            return null;
        }
        return credentials;
    }

    protected String getServicePlan(VcapServices vcapServices, String bindingName) throws AuditLogWriteException {
        Service auditService = this.getAuditService(vcapServices, bindingName);
        if (auditService == null) {
            LOGGER.error(CANNOT_GET_PLAN_OF_AUDITLOG_SERVICE_ERROR_MESSAGE);
            return null;
        }
        return auditService.getPlan();
    }

    boolean areXsuaaCredentialsExisting(Credentials credentials) throws AuditLogWriteException {
        Object uaaObj = credentials.any().get("uaa");
        if (uaaObj == null) {
            return false;
        }
        try {
            String jsonInString = MAPPER.writeValueAsString(uaaObj);
            OAuthCredentials oauthCredentials = (OAuthCredentials)MAPPER.readValue(jsonInString, OAuthCredentials.class);
            return oauthCredentials.getClientid() != null && oauthCredentials.getUrl() != null;
        }
        catch (IOException e) {
            throw new AuditLogWriteException(PARSING_CREDENTIALS_ERROR, e);
        }
    }

    boolean areStandardCredentialsExisting(Credentials credentials) {
        return credentials.getUrl() != null && credentials.getUser() != null && credentials.getPassword() != null;
    }

    private Service getAuditService(VcapServices vcapServices, String bindingName) throws AuditLogWriteException {
        vcapServices = vcapServices == null ? VcapServices.fromEnvironment() : vcapServices;
        Service auditService = this.getService(vcapServices, bindingName);
        return auditService;
    }

    private String getUaaDomainFromXsuaaUrl(String xsuaaUrl) throws AuditLogWriteException {
        String uaaDomain;
        if (xsuaaUrl == null || xsuaaUrl.isEmpty()) {
            throw new AuditLogWriteException(UNABLE_TO_GET_XSUAA_DOMAIN_ERROR_MESSAGE);
        }
        try {
            uaaDomain = new URL(xsuaaUrl).getHost();
        }
        catch (MalformedURLException e) {
            throw new AuditLogWriteException(UNABLE_TO_GET_XSUAA_DOMAIN_ERROR_MESSAGE);
        }
        String[] splitUrl = uaaDomain.split(DOT_REGEX, 0);
        if (splitUrl.length > 0) {
            uaaDomain = uaaDomain.replace(splitUrl[0], "");
            uaaDomain = uaaDomain.replaceFirst(DOT_REGEX, "");
            return uaaDomain;
        }
        throw new AuditLogWriteException(UNABLE_TO_GET_XSUAA_DOMAIN_ERROR_MESSAGE);
    }

    private String getUaaDomainFromXsuaaCertUrl(String xsuaaCertUrl) throws AuditLogWriteException {
        return this.getUaaDomainFromXsuaaUrl(xsuaaCertUrl).replaceAll(CERT_REGEX, ".");
    }

    private Service getService(VcapServices vcapServices, String bindingName) throws AuditLogWriteException {
        if (bindingName != null) {
            List auditLogServices = vcapServices.findServices(AUDIT_LOG_SERVICE_NAME, BINDING_NAME_ATTRIBUTE, bindingName);
            return this.findServiceByBindingName(auditLogServices, bindingName);
        }
        return vcapServices.findService(AUDIT_LOG_SERVICE_NAME, null, null);
    }

    private Service findServiceByBindingName(List<Service> services, String bindingName) throws AuditLogWriteException {
        for (Service service : services) {
            if (!this.serviceHasBindingName(service, bindingName)) continue;
            return service;
        }
        throw new AuditLogWriteException(NO_BINDING_WITH_GIVEN_NAME + bindingName);
    }

    private boolean serviceHasBindingName(Service auditlogService, String bindingName) {
        return bindingName.equals((String)auditlogService.get(BINDING_NAME_ATTRIBUTE));
    }
}

