/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.sap.xs.audit.message.Attribute;
import com.sap.xs.audit.message.AuditLogMessageCategory;
import com.sap.xs.audit.message.TransactionalMessage;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.v2.AuditedObjectPOJO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"uuid", "user", "time", "id", "success", "object_id", "object", "attributes"})
public class ConfigurationChange
extends TransactionalMessage {
    @JsonProperty(value="attributes", required=true)
    private List<Attribute> attributes = new ArrayList<Attribute>();
    @JsonProperty(value="object_id", required=true)
    private String objectId;
    @JsonProperty(value="object", required=true)
    private AuditedObjectPOJO object;

    public ConfigurationChange() {
        super(AuditLogMessageCategory.CONFIGURATION_CHANGE.getCategoryId());
    }

    @JsonIgnore
    public String getObjectId() {
        return this.objectId;
    }

    @JsonIgnore
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @JsonIgnore
    public String getObject() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this.object);
    }

    @JsonIgnore
    public void setObject(AuditedObjectPOJO object) {
        this.object = object;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, String oldValue, String newValue) {
        this.attributes.add(new Attribute(name, oldValue, newValue));
    }

    @Override
    @JsonIgnore
    public void validate() throws ValidationError {
        this.validate("v2");
    }

    @JsonIgnore
    public void validate(String version) throws ValidationError {
        super.validate();
        if (this.attributes == null || this.attributes.isEmpty()) {
            this.errors.put("attributes", "The 'attributes' property cannot be null or empty");
        } else {
            HashSet<String> nameSet = new HashSet<String>();
            for (int index = 0; index < this.attributes.size(); ++index) {
                Attribute attribute = this.attributes.get(index);
                try {
                    attribute.validate();
                }
                catch (ValidationError e) {
                    this.errors.put("name <" + index + ">", e.getMessage());
                }
                nameSet.add(attribute.getName());
            }
            if (nameSet.size() != this.attributes.size()) {
                this.errors.put("attributes", "'attributes' property should contain unique items");
            }
        }
        if ("v2".equals(version)) {
            if (this.object == null) {
                this.errors.put("object", "'object' property cannot be null or empty");
            } else {
                if (this.object.getType() == null) {
                    this.errors.put("object.type", "'object.type' property cannot be null or empty");
                }
                if (this.object.getId().size() == 0) {
                    this.errors.put("object.id", "'object.id' property cannot be null or empty");
                }
            }
            if (this.objectId != null) {
                this.errors.put("objectId", "'objectId' is not valid attribute for V2 API");
            }
        }
        if (this.errors.size() > 0) {
            throw new ValidationError("The audit message contains some invalid properties. For more details use the getErrors() method");
        }
    }
}

