/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.sap.xs.audit.message.Attribute;
import com.sap.xs.audit.message.AuditLogMessageCategory;
import com.sap.xs.audit.message.TransactionalMessage;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.v2.AuditedDataSubjectPOJO;
import com.sap.xs.audit.message.v2.AuditedObjectPOJO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uuid", "user", "time", "object_id", "object", "data_subject", "attributes", "data"})
public class DataModification
extends TransactionalMessage {
    @JsonProperty(value="attributes", required=true)
    private List<Attribute> attributes = new ArrayList<Attribute>();
    @JsonProperty(value="object_id", required=true)
    private String objectId;
    @JsonProperty(value="data_subject")
    private AuditedDataSubjectPOJO subject;
    @JsonProperty(value="object", required=true)
    private AuditedObjectPOJO object;

    public DataModification() {
        super(AuditLogMessageCategory.DATA_MODIFICATION.getCategoryId());
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @JsonIgnore
    public String getObject() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this.object);
    }

    @JsonIgnore
    public void setObject(AuditedObjectPOJO object) {
        this.object = object;
    }

    @JsonIgnore
    public String getDataSubject() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this.subject);
    }

    @JsonIgnore
    public void setDataSubject(AuditedDataSubjectPOJO subject) {
        this.subject = subject;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, Boolean isSuccessful) {
        this.addAttribute(name, null, null, isSuccessful);
    }

    public void addAttribute(String name, String oldValue, String newValue, Boolean isSuccessful) {
        this.attributes.add(new Attribute(name, oldValue, newValue, isSuccessful));
    }

    @Override
    @JsonIgnore
    public void validate() throws ValidationError {
        this.validate("v2");
    }

    @JsonIgnore
    public void validate(String version) throws ValidationError {
        super.validate();
        if ("v2".equals(version)) {
            this.validateAttributes("v2");
            if (this.object == null) {
                this.errors.put("object", "'object' property cannot be null or empty");
            } else {
                if (this.object.getType() == null) {
                    this.errors.put("object.type", "'object.type' property cannot be null or empty");
                }
                if (this.object.getId().size() == 0) {
                    this.errors.put("object.id", "'object.id' property cannot be null or empty");
                }
            }
            if (this.subject == null) {
                this.errors.put("subject", "'data_subject' property cannot be null or empty");
            } else {
                if (this.subject.getType() == null) {
                    this.errors.put("subject.type", "'data_subject.type' property cannot be null or empty");
                }
                if (this.subject.getId().size() == 0) {
                    this.errors.put("subject.id", "'data_subject.id' property cannot be null or empty");
                }
            }
            if (this.objectId != null) {
                this.errors.put("objectId", "'objectId' is not valid attribute for V2 API");
            }
        } else {
            this.validateAttributes("v1");
        }
        if (this.errors.size() > 0) {
            throw new ValidationError("The audit message contains some invalid properties. For more details use the getErrors() method");
        }
    }

    private void validateAttributes(String version) {
        if (this.attributes == null || this.attributes.isEmpty()) {
            this.errors.put("attributes", "The 'attributes' property cannot be null or empty");
        } else {
            HashSet<String> nameSet = new HashSet<String>();
            for (int index = 0; index < this.attributes.size(); ++index) {
                Attribute attribute = this.attributes.get(index);
                try {
                    if (version.equalsIgnoreCase("v2")) {
                        attribute.validateV2();
                    } else {
                        attribute.validate();
                    }
                }
                catch (ValidationError e) {
                    this.errors.put("name <" + index + ">", e.getMessage());
                }
                nameSet.add(attribute.getName());
            }
            if (nameSet.size() != this.attributes.size()) {
                this.errors.put("attributes", "'attributes' property should contain unique items");
            }
        }
    }
}

