/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.sap.xs.audit.message.AuditLogMessageBase;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.InstantDeserializer;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AuditLogMessage
extends AuditLogMessageBase {
    @JsonProperty(value="uuid", required=true)
    protected String uuid;
    @JsonProperty(value="user", required=true)
    private String user;
    @JsonProperty(value="identityProvider")
    private String identityProvider;
    @JsonProperty(value="tenant", required=false)
    private String tenant;
    @JsonIgnore
    private String subscriberTokenIssuer;
    @JsonProperty(value="customDetails")
    private Map<String, Object> customDetails = new HashMap<String, Object>();
    @JsonProperty(value="time", required=true)
    @JsonSerialize(using=ToStringSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    private Instant time;
    private String app;
    private String org;
    private String space;
    private String instance;

    public AuditLogMessage() {
    }

    protected AuditLogMessage(String category) {
        super(category);
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(String idp) {
        this.identityProvider = idp;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getSubscriberTokenIssuer() {
        return this.subscriberTokenIssuer;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setSubscriberTokenIssuer(String subscriberTokenIssuer) {
        this.subscriberTokenIssuer = subscriberTokenIssuer;
    }

    public Map<String, Object> getCustomDetails() {
        return this.customDetails;
    }

    @JsonIgnore
    public void addCustomDetails(String key, Object value) {
        this.customDetails.put(key, value);
    }

    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    @JsonIgnore
    public void validate() throws ValidationError {
        if (this.uuid == null) {
            this.errors.put("uuid", "'uuid' property cannot be null");
        }
        if (this.user == null) {
            this.errors.put("user", "'user' property cannot be null");
        }
        if (this.time == null) {
            this.errors.put("time", "'time' property cannot be null");
        }
        this.validateCategory();
    }

    public String toString() {
        return " app=" + this.app + ", org=" + this.org + ", space=" + this.space + ", instance=" + this.instance + ", uuid=" + this.uuid + ", user=" + this.user + ", identityProvider=" + this.identityProvider + ", tenant=" + this.tenant + ", time=" + this.time + "customAttributes=" + this.customDetails;
    }
}

