/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.exception.ClientInitializationException;
import com.sap.cds.repackaged.audit.client.impl.ConnectionConfigLoader;
import com.sap.cds.repackaged.audit.client.impl.OAuthCredentials;
import com.sap.cloud.security.mtls.SSLContextFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class HttpClientFactory {
    private static final String HTTPS_SCHEME = "https";
    private static final String PARSING_CREDENTIALS_ERROR = "Problem occurred while trying to parse XSUAA credentials";
    private static final String SECURITY_ERROR = "Security error has occured";
    private SSLContextFactory sslContextFactory;
    private OAuthCredentials oauthCredentials;
    private ConnectionConfigLoader configLoader;
    private List<Header> httpHeaders;

    public HttpClientFactory(SSLContextFactory sslContextFactory, OAuthCredentials oauthCredentials, ConnectionConfigLoader configLoader) {
        this.sslContextFactory = sslContextFactory;
        this.oauthCredentials = oauthCredentials;
        this.configLoader = configLoader;
        this.httpHeaders = this.getDefaultHeaders();
    }

    public HttpClient createHttpClient(PoolingHttpClientConnectionManager connectionManager) {
        HttpClientBuilder customHttpClientBuilder = this.createHttpClientBuilder(connectionManager);
        return customHttpClientBuilder.build();
    }

    public HttpClient createHttpClientWithSSLContext(PoolingHttpClientConnectionManager connectionManager) {
        HttpClientBuilder customHttpClientBuilder = this.createHttpClientBuilder(connectionManager);
        try {
            this.enhanceClientWithSSLContext(customHttpClientBuilder, this.oauthCredentials);
        }
        catch (IOException e) {
            throw new ClientInitializationException(PARSING_CREDENTIALS_ERROR, e);
        }
        catch (GeneralSecurityException e) {
            throw new ClientInitializationException(SECURITY_ERROR, e);
        }
        return customHttpClientBuilder.build();
    }

    private HttpClientBuilder createHttpClientBuilder(PoolingHttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(this.getRequestConfig()).setKeepAliveStrategy((resp, ctx) -> this.configLoader.getConnectionKeepAliveTime()).setDefaultHeaders(this.httpHeaders);
    }

    private void enhanceClientWithSSLContext(HttpClientBuilder customHttpClientBuilder, OAuthCredentials oauthCredentials) throws GeneralSecurityException, IOException {
        if (oauthCredentials != null && oauthCredentials.getCertificate() != null && oauthCredentials.getKey() != null) {
            SSLContext sslContext = this.sslContextFactory.create(oauthCredentials.getCertificate(), oauthCredentials.getKey());
            customHttpClientBuilder.setSSLContext(sslContext);
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext);
            Registry registry = RegistryBuilder.create().register(HTTPS_SCHEME, (Object)sslConnectionFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
            connectionManager.setMaxTotal(this.configLoader.getHttpPoolMaxConn());
            connectionManager.setDefaultMaxPerRoute(this.configLoader.getHttpPoolMaxConnPerRoute());
            customHttpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
    }

    private RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(this.configLoader.getConnectionRequestTimeout()).setConnectTimeout(this.configLoader.getConnectTimeout()).setSocketTimeout(this.configLoader.getSocketTimeout()).build();
    }

    private List<Header> getDefaultHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        BasicHeader contentHeader = new BasicHeader("Content-Type", "application/json; charset=utf-8");
        headers.add((Header)contentHeader);
        return headers;
    }
}

