/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.api.exception.InvalidTokenIssuerException;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.ConnectionConfigLoader;
import com.sap.cds.repackaged.audit.client.impl.HttpClientFactory;
import com.sap.cds.repackaged.audit.client.impl.OAuthCredentials;
import com.sap.cds.repackaged.audit.client.impl.ServiceCredentialParser;
import com.sap.cds.repackaged.audit.client.impl.TokenFactory;
import com.sap.cds.repackaged.audit.client.impl.XsuaaTokenFlowsFactory;
import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.mtls.SSLContextFactory;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlows;
import com.sap.xs.env.Credentials;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCommunicator
implements Communicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommunicator.class);
    private final String serviceUrl;
    private final String servicePlan;
    private final Credentials serviceCredentials;
    private final HttpClient httpClient;
    private final OAuthCredentials oauthCredentials;
    private final XsuaaTokenFlowsFactory tokenFlowsFactory;
    private final ConnectionConfigLoader configLoader;
    private HttpClientContext localContext;
    private static final String ERR_MSG_TEMPLATE = "Audit log client received HTTP status code %s from audit service. Audit log might not have been written in the audit log storage. Audit service response: \"%s\".";
    private static final String ERR_MSG_RETRY_TEMPLATE = "Audit log client made %s failed attempts to send the audit log message. The message might not have been written in the audit log storage. Received HTTP status code is %s and response body: \"%s\".";
    private static final String ERR_MSG_EXC_TEMPLATE = "Could not send the audit log message to the audit log service after %s failed connection attempts. Exception is: %s";
    private static final String OBTAINING_TOKEN_ERROR = "Problem occurred while trying to obtain token";
    private static final String REGEX_DOT_SPLIT = "\\.";
    private static final String REGEX_DOT_JOIN = ".";
    private static final String CERT_PATH = "cert";
    private static final int CERT_PATH_INDEX = 1;

    public HttpCommunicator(Credentials credentials, String plan, String versionedAuditServiceURLPath, String connConfigJson, SSLContextFactory sslContextFactory, PoolingHttpClientConnectionManager httpClientConnectionManager) {
        this(credentials, new ServiceCredentialParser(credentials).parseCredentials(), plan, versionedAuditServiceURLPath, connConfigJson, sslContextFactory, httpClientConnectionManager);
    }

    public HttpCommunicator(Credentials credentials, String plan, String versionedAuditServiceURLPath) {
        this(credentials, plan, versionedAuditServiceURLPath, null, SSLContextFactory.getInstance(), new PoolingHttpClientConnectionManager());
    }

    public HttpCommunicator(Credentials credentials, String plan, String versionedAuditServiceURLPath, SSLContextFactory sslContextFactory, PoolingHttpClientConnectionManager httpClientConnectionManager) {
        this(credentials, plan, versionedAuditServiceURLPath, null, sslContextFactory, httpClientConnectionManager);
    }

    protected HttpCommunicator(Credentials credentials, OAuthCredentials oauthCredentials, String plan, String versionedAuditServiceURLPath, String connConfigJson, SSLContextFactory sslContextFactory, PoolingHttpClientConnectionManager httpClientConnectionManager) {
        this.configLoader = new ConnectionConfigLoader(connConfigJson);
        httpClientConnectionManager.setMaxTotal(this.configLoader.getHttpPoolMaxConn());
        httpClientConnectionManager.setDefaultMaxPerRoute(this.configLoader.getHttpPoolMaxConnPerRoute());
        this.serviceCredentials = credentials;
        this.oauthCredentials = oauthCredentials;
        HttpClientFactory httpClientFactory = new HttpClientFactory(sslContextFactory, oauthCredentials, this.configLoader);
        this.httpClient = httpClientFactory.createHttpClient(httpClientConnectionManager);
        HttpClient httpClientWithSSLContext = httpClientFactory.createHttpClientWithSSLContext(httpClientConnectionManager);
        this.tokenFlowsFactory = new XsuaaTokenFlowsFactory(httpClientWithSSLContext);
        this.serviceUrl = versionedAuditServiceURLPath;
        this.servicePlan = plan;
    }

    private String getAuthorizationHeader(String subscriberTokenIssuer) throws AuditLogWriteException, InvalidTokenIssuerException {
        return this.servicePlan.equals("oauth2") ? this.getAuthHeaderValueForOAuth2Auth(subscriberTokenIssuer) : this.getAuthHeaderValueForBasicAuth();
    }

    String getAuthHeaderValueForBasicAuth() throws AuditLogWriteException {
        String username = this.serviceCredentials.getUser();
        String password = this.serviceCredentials.getPassword();
        String plainCredentials = username + ":" + password;
        String encodedCredentials = Base64.getEncoder().encodeToString(plainCredentials.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic " + encodedCredentials;
    }

    String getAuthHeaderValueForOAuth2Auth(String subscriberTokenIssuer) throws AuditLogWriteException, InvalidTokenIssuerException {
        TokenFactory tokenFactory = this.getTokenFactory(subscriberTokenIssuer);
        String accessToken = this.obtainToken(tokenFactory);
        if (accessToken == null) {
            throw new AuditLogWriteException(OBTAINING_TOKEN_ERROR);
        }
        return "Bearer " + accessToken;
    }

    protected TokenFactory getTokenFactory(String subscriberTokenIssuer) throws AuditLogWriteException, InvalidTokenIssuerException {
        OAuthCredentials oauthCredentials = this.createOAuthCredentials(subscriberTokenIssuer);
        XsuaaTokenFlows tokenFlows = this.tokenFlowsFactory.getXsuaaTokenFlows(oauthCredentials);
        return new TokenFactory(tokenFlows);
    }

    private OAuthCredentials createOAuthCredentials(String subscriberTokenIssuer) throws AuditLogWriteException {
        this.oauthCredentials.setSubscriberTokenIssuer(subscriberTokenIssuer);
        return this.oauthCredentials;
    }

    String obtainToken(TokenFactory tokenFactory) throws AuditLogWriteException {
        try {
            return tokenFactory.getClientCredentialsGrantAccessToken();
        }
        catch (TokenFlowException e) {
            throw new AuditLogWriteException(OBTAINING_TOKEN_ERROR, e);
        }
    }

    @Override
    public String send(String message, String endpoint, String subscriberTokenIssuer) throws AuditLogWriteException, UnsupportedOperationException {
        try {
            int messageHash = System.identityHashCode(message);
            LOGGER.debug("Persisting audit log ({}): '{}'.", (Object)messageHash, (Object)message);
            String authorizatioHeader = this.getAuthorizationHeader(subscriberTokenIssuer);
            HttpPost request = this.createPostRequest(message, endpoint, authorizatioHeader);
            HttpResponse response = this.sendAndRetryOnHttpErrorCodes((HttpEntityEnclosingRequestBase)request);
            String responseBody = HttpCommunicator.consumeResponse(response);
            int statusCode = response.getStatusLine().getStatusCode();
            LOGGER.debug("Status code ({}): '{}'.", (Object)messageHash, (Object)statusCode);
            LOGGER.debug("Response ({}): '{}'.", (Object)messageHash, (Object)responseBody);
            if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                LOGGER.debug("Persisted audit log ({}).", (Object)messageHash);
                return responseBody;
            }
            throw new AuditLogWriteException(String.format(ERR_MSG_TEMPLATE, statusCode, responseBody));
        }
        catch (Exception e) {
            if (e instanceof AuditLogWriteException) {
                throw (AuditLogWriteException)e;
            }
            throw new AuditLogWriteException("Unable to persist audit log!", e);
        }
    }

    HttpPost createPostRequest(String message, String endpoint, String authorizationHeader) throws AuditLogWriteException {
        HttpPost request = new HttpPost(endpoint);
        request.setHeader("Authorization", authorizationHeader);
        StringEntity params = new StringEntity(message, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)params);
        return request;
    }

    private HttpResponse sendAndRetryOnHttpErrorCodes(HttpEntityEnclosingRequestBase request) throws AuditLogWriteException {
        HttpResponse lastResponse = null;
        int statusCode = 0;
        String responseBody = null;
        for (int i = 0; i <= this.configLoader.getMaxRetryCountOnHttpErrorResponse(); ++i) {
            if (lastResponse != null) {
                LOGGER.debug("Received response with HTTP status code: {} and response body: \"{}\". Request will be retried {} more times.", new Object[]{statusCode, responseBody, this.configLoader.getMaxRetryCountOnHttpErrorResponse() - i + 1});
                this.waitBeforeRetry(this.configLoader.getDelayRetryOnHttpErrorResponse());
            }
            if (!this.isRetryOnRC(statusCode = (lastResponse = this.sendAndRetryOnException(request)).getStatusLine().getStatusCode())) {
                return lastResponse;
            }
            responseBody = HttpCommunicator.consumeResponse(lastResponse);
        }
        throw new AuditLogWriteException(String.format(ERR_MSG_RETRY_TEMPLATE, this.configLoader.getMaxRetryCountOnHttpErrorResponse() + 1, statusCode, responseBody));
    }

    private HttpResponse sendAndRetryOnException(HttpEntityEnclosingRequestBase request) throws AuditLogWriteException {
        HttpResponse response = null;
        IOException exception = null;
        for (int i = 0; i <= this.configLoader.getMaxRetryCountOnException(); ++i) {
            try {
                response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)this.localContext);
                exception = null;
                break;
            }
            catch (IOException e) {
                exception = e;
                LOGGER.warn("Connection attempt failed: {}. Retrying ...", (Object)e.getMessage());
                this.waitBeforeRetry(this.configLoader.getDelayRetryOnException());
                continue;
            }
        }
        if (exception != null) {
            String err = String.format(ERR_MSG_EXC_TEMPLATE, this.configLoader.getMaxRetryCountOnException() + 1, exception.getMessage());
            LOGGER.error(err);
            throw new AuditLogWriteException(err, exception);
        }
        return response;
    }

    private boolean waitBeforeRetry(long waitTime) {
        if (waitTime != 0L) {
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException interrupted) {
                LOGGER.warn("Delay before connection retry for sending an auditlog message was interrupted.");
                return false;
            }
        }
        return true;
    }

    private static String consumeResponse(HttpResponse response) {
        String responseBody = "";
        try {
            HttpEntity entity = null;
            if (response != null && (entity = response.getEntity()) != null) {
                responseBody = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot consume the response from the connection.", (Throwable)e);
        }
        return responseBody;
    }

    private boolean isRetryOnRC(int rc) {
        return rc == 404 || rc == 503 || rc == 500 || rc == 502 || rc == 504;
    }

    @Override
    public String getClientId() {
        return this.servicePlan.equals("oauth2") ? this.oauthCredentials.getClientid() : null;
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public String getServicePlan() {
        return this.servicePlan;
    }

    @Override
    public String getUaaDomain() {
        String uaaDomain = this.oauthCredentials.getUaaDomain();
        LOGGER.debug("Getting uaaDomain: ({}).", (Object)uaaDomain);
        if (this.isX509CredentialType()) {
            ArrayList<String> uaaDomainArray = new ArrayList<String>(Arrays.asList(uaaDomain.split(REGEX_DOT_SPLIT)));
            uaaDomainArray.add(1, CERT_PATH);
            return String.join((CharSequence)REGEX_DOT_JOIN, uaaDomainArray);
        }
        return uaaDomain;
    }

    @Override
    public boolean isX509CredentialType() {
        return CredentialType.X509.toString().equals(this.oauthCredentials.getCredentialType());
    }
}

