/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl.v2;

import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.api.v2.AuditedDataSubject;
import com.sap.cds.repackaged.audit.api.v2.AuditedObject;
import com.sap.cds.repackaged.audit.api.v2.DataModificationAuditMessage;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.TransactionalLogImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditedDataSubjectImpl;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditedObjectImpl;
import com.sap.xs.audit.message.DataModification;
import java.util.UUID;

public class DataModificationMessageImpl
extends TransactionalLogImpl<DataModification>
implements DataModificationAuditMessage {
    DataModificationMessageImpl(Communicator communicator) {
        super(communicator);
        this.endpoint = communicator.getServiceUrl() + "data-modifications";
        this.message = new DataModification();
        ((DataModification)this.message).setUuid(UUID.randomUUID().toString());
    }

    @Override
    public void addAttribute(String name, String oldValue, String newValue) {
        this.ensureNotLogged();
        ((DataModification)this.message).addAttribute(name, oldValue, newValue, null);
    }

    @Override
    public void log() throws AuditLogNotAvailableException, AuditLogWriteException {
        this.logSuccess();
    }

    @Override
    public void setObject(AuditedObject ao) {
        this.ensureNotLogged();
        ((DataModification)this.message).setObject(((AuditedObjectImpl)ao).getAuditedObjectPOJO());
    }

    @Override
    public void setDataSubject(AuditedDataSubject ads) {
        this.ensureNotLogged();
        ((DataModification)this.message).setDataSubject(((AuditedDataSubjectImpl)ads).getAuditedDataSubjectPOJO());
    }
}

