/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sap.cds.repackaged.audit.api.AuditLogMessage;
import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.Utils;
import com.sap.cds.repackaged.audit.client.impl.v2.AuditLogMessageFactoryImpl;
import com.sap.xs.audit.message.AuditLogMessageBase;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.JsonParserUtils;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuditLogMessageImpl<T extends com.sap.xs.audit.message.AuditLogMessage>
implements AuditLogMessage {
    protected static Logger LOGGER = LoggerFactory.getLogger(AuditLogMessageImpl.class);
    private static final String ALREADY_LOGGED = "Audit message has already been logged. No changes possible.";
    protected static final String ALREADY_LOGGED_WARNING = "Audit message ignored as it has already been persisted successfully.";
    private static final String SUBSCRIBER_URL_TEMPLATE_PATH = "https://%s.%s";
    protected boolean alreadyPrepared = false;
    protected boolean alreadyLogged = false;
    protected String endpoint;
    protected T message;
    protected Instant eventTime;
    protected AuditLogMessageFactoryImpl factory;
    protected Communicator communicator;

    public AuditLogMessageImpl(Communicator communicator) {
        this.communicator = communicator;
    }

    protected void ensureNotLogged() throws IllegalStateException {
        if (this.alreadyPrepared || this.alreadyLogged) {
            throw new IllegalStateException(ALREADY_LOGGED);
        }
    }

    public String serializeMessage() throws AuditLogWriteException {
        try {
            return JsonParserUtils.serializeMessage(this.message);
        }
        catch (JsonProcessingException e) {
            throw new AuditLogWriteException("Cannot serialize audit message " + e);
        }
    }

    protected String serializeMessage(Object message) throws AuditLogWriteException {
        try {
            return JsonParserUtils.serializeMessage(message);
        }
        catch (JsonProcessingException e) {
            throw new AuditLogWriteException("Cannot serialize audit message " + e);
        }
    }

    @Override
    public void log() throws AuditLogNotAvailableException, AuditLogWriteException {
        if (this.alreadyLogged) {
            LOGGER.warn(ALREADY_LOGGED_WARNING);
            return;
        }
        if (((com.sap.xs.audit.message.AuditLogMessage)this.message).getUser() == null || "$USER".equals(((com.sap.xs.audit.message.AuditLogMessage)this.message).getUser())) {
            String user = Utils.getUser();
            ((com.sap.xs.audit.message.AuditLogMessage)this.message).setUser(user != null ? user : this.communicator.getClientId());
        }
        if (this.eventTime == null) {
            this.eventTime = Instant.now();
        }
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setTime(this.eventTime);
        try {
            this.validateUser(((com.sap.xs.audit.message.AuditLogMessage)this.message).getUser());
            this.validateIdentityProvider(((com.sap.xs.audit.message.AuditLogMessage)this.message).getIdentityProvider());
            this.validateTenant(((com.sap.xs.audit.message.AuditLogMessage)this.message).getTenant());
            ((com.sap.xs.audit.message.AuditLogMessage)this.message).validate();
        }
        catch (ValidationError e) {
            throw new AuditLogWriteException("Audit log message cannot be validated. " + e.getMessage(), ((AuditLogMessageBase)this.message).getErrors());
        }
        this.communicator.send(this.serializeMessage(), this.endpoint, ((com.sap.xs.audit.message.AuditLogMessage)this.message).getSubscriberTokenIssuer());
        this.alreadyLogged = true;
    }

    @Override
    public void setUser(String user) {
        this.ensureNotLogged();
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setUser(user);
    }

    @Override
    public void setIdentityProvider(String idp) {
        this.ensureNotLogged();
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setIdentityProvider(idp);
    }

    @Override
    public void setTenant(String tenant) {
        this.ensureNotLogged();
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setTenant(tenant);
    }

    @Override
    public void setTenant(String tenant, String subscriberTokenIssuer) {
        this.ensureNotLogged();
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setSubscriberTokenIssuer(subscriberTokenIssuer);
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setTenant(tenant);
    }

    @Override
    public void setTenantBySubscriberSubdomain(String subdomain) {
        this.ensureNotLogged();
        String uaaDomain = this.communicator.getUaaDomain();
        String subscriberTokenIssuer = String.format(SUBSCRIBER_URL_TEMPLATE_PATH, subdomain, uaaDomain);
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setSubscriberTokenIssuer(subscriberTokenIssuer);
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setTenant("$SUBSCRIBER");
    }

    @Override
    public void addCustomDetails(String key, Object value) {
        this.ensureNotLogged();
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).addCustomDetails(key, value);
    }

    @Override
    public void setEventTime(Instant time) {
        this.eventTime = time;
    }

    @Override
    @Deprecated
    public void setTime(Instant time) {
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setTime(time);
    }

    @Override
    @Deprecated
    public void setUuid(String uuid) {
        ((com.sap.xs.audit.message.AuditLogMessage)this.message).setUuid(uuid);
    }

    private void validateUser(String user) throws ValidationError {
        String plan = this.communicator.getServicePlan();
        if ("oauth2".equals(plan) && this.isUserValueInvalid(user)) {
            throw new ValidationError("The user field of the Audit log message should not be empty for the 'oauth2' scenario!");
        }
    }

    private void validateIdentityProvider(String identityProvider) throws ValidationError {
        String plan = this.communicator.getServicePlan();
        if ("oauth2".equals(plan) && this.isIdPValueInvalid(identityProvider)) {
            throw new ValidationError("The identityProvider field of the Audit log message is invaid for the 'oauth2' scenario!");
        }
    }

    private void validateTenant(String tenant) throws ValidationError {
        String plan = this.communicator.getServicePlan();
        if ("oauth2".equals(plan) && this.isTenantValueInvalid(tenant)) {
            throw new ValidationError("The tenant field of the Audit log message is invaid for the 'oauth2' scenario!");
        }
    }

    private boolean isTenantValueInvalid(String tenant) {
        return !"$PROVIDER".equals(tenant) && !"$SUBSCRIBER".equals(tenant);
    }

    private boolean isUserValueInvalid(String user) {
        if (user != null) {
            return user.trim().isEmpty();
        }
        return true;
    }

    private boolean isIdPValueInvalid(String identityProvider) {
        return identityProvider != null && !"$IDP".equals(identityProvider);
    }
}

