/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextToken {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContextToken.class);
    private final Token token;

    public SecurityContextToken(Token token) {
        this.token = token;
    }

    public String getClientId() {
        return this.token.getClientId();
    }

    public String getLogonName() {
        return this.token.getPrincipal().getName();
    }

    public String getGrantType() {
        if (Service.XSUAA != this.token.getService()) {
            LOGGER.warn("There is no GRANT_TYPE claim for token of type {}", (Object)this.token.getService());
            return null;
        }
        GrantType grantType = ((AccessToken)this.token).getGrantType();
        if (grantType == null) {
            LOGGER.warn("The enum of token's grant type [%s] cannot be found!", (Object)this.token.getClaimAsString("grant_type"));
            return null;
        }
        return grantType == GrantType.CLIENT_CREDENTIALS ? "client" : "user";
    }

    public String getToken() {
        return this.token.getTokenValue();
    }

    public String getSubdomain() {
        return this.token.getAttributeFromClaimAsString("ext_attr", "zdn");
    }
}

