/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.repackaged.audit.client.impl;

import com.sap.cds.repackaged.audit.api.TransactionalAuditLogMessage;
import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;
import com.sap.cds.repackaged.audit.api.v2.AuditLogMessageFactory;
import com.sap.cds.repackaged.audit.client.impl.AuditLogIdentifier;
import com.sap.cds.repackaged.audit.client.impl.AuditLogMessageImpl;
import com.sap.cds.repackaged.audit.client.impl.Communicator;
import com.sap.cds.repackaged.audit.client.impl.Utils;
import com.sap.xs.audit.message.TransactionalMessage;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.JsonParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.UUID;

public class TransactionalLogImpl<T extends TransactionalMessage>
extends AuditLogMessageImpl<T>
implements TransactionalAuditLogMessage {
    public TransactionalLogImpl(Communicator communicator) {
        super(communicator);
    }

    public TransactionalLogImpl(AuditLogMessageFactory factory, Communicator communicator) {
        super(communicator);
    }

    @Override
    public void logPrepare() throws AuditLogNotAvailableException, AuditLogWriteException {
        if (this.alreadyLogged) {
            LOGGER.warn("Audit message ignored as it has already been persisted successfully.");
            return;
        }
        if (((TransactionalMessage)this.message).getUser() == null || "$USER".equals(((TransactionalMessage)this.message).getUser())) {
            String user = Utils.getUser();
            ((TransactionalMessage)this.message).setUser(user != null ? user : this.communicator.getClientId());
        }
        if (this.eventTime == null) {
            this.eventTime = Instant.now();
        }
        ((TransactionalMessage)this.message).setTime(this.eventTime);
        ((TransactionalMessage)this.message).setStatus("BEGIN");
        try {
            ((TransactionalMessage)this.message).validate();
        }
        catch (ValidationError e) {
            LOGGER.error("Audit log message cannot be validated.");
            throw new AuditLogWriteException("Audit log message cannot be validated.", ((TransactionalMessage)this.message).getErrors());
        }
        try {
            String resp = this.communicator.send(this.serializeMessage(), this.endpoint, ((TransactionalMessage)this.message).getSubscriberTokenIssuer());
            AuditLogIdentifier auditLogIdentifier = JsonParserUtils.desrializeMessage(resp, AuditLogIdentifier.class);
            ((TransactionalMessage)this.message).setId(auditLogIdentifier.getId());
            this.alreadyPrepared = true;
        }
        catch (IOException e) {
            throw new AuditLogWriteException("Audit server returned invalid response.", e);
        }
    }

    @Override
    public void logSuccess() throws AuditLogNotAvailableException, AuditLogWriteException {
        this.logStatus(true);
    }

    @Override
    public void logFailure() throws AuditLogNotAvailableException, AuditLogWriteException {
        this.logStatus(false);
    }

    private void logStatus(boolean success) throws AuditLogNotAvailableException, AuditLogWriteException {
        if (this.alreadyLogged) {
            LOGGER.warn("Audit message ignored as it has already been persisted successfully.");
            return;
        }
        ((TransactionalMessage)this.message).setUuid(UUID.randomUUID().toString());
        if (((TransactionalMessage)this.message).getUser() == null || "$USER".equals(((TransactionalMessage)this.message).getUser())) {
            String user = Utils.getUser();
            ((TransactionalMessage)this.message).setUser(user != null ? user : this.communicator.getClientId());
        }
        if (this.eventTime == null) {
            this.eventTime = Instant.now();
        }
        ((TransactionalMessage)this.message).setTime(this.eventTime);
        try {
            ((TransactionalMessage)this.message).validate();
        }
        catch (ValidationError e) {
            throw new AuditLogWriteException("Audit log message cannot be validated.", ((TransactionalMessage)this.message).getErrors());
        }
        ((TransactionalMessage)this.message).setSuccess(success);
        ((TransactionalMessage)this.message).setStatus("END");
        this.communicator.send(this.serializeMessage(), this.endpoint, ((TransactionalMessage)this.message).getSubscriberTokenIssuer());
        this.alreadyLogged = true;
    }
}

