/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.xs.audit.message.AuditLogMessageCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuditLogMessageBase {
    protected static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonIgnore
    protected Map<String, String> errors = new HashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="category", required=false)
    private String category;

    public AuditLogMessageBase() {
    }

    protected AuditLogMessageBase(String category) {
        this.category = Objects.requireNonNull(category);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @JsonIgnore
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @JsonIgnore
    protected void validateCategory() {
        boolean match = Optional.ofNullable(this.category).flatMap(AuditLogMessageCategory::fromCategoryId).map(AuditLogMessageCategory::getAuditLogMessageClass).map(clazz -> clazz.isInstance(this)).orElse(false);
        if (!match) {
            this.errors.put("category", "'category' property does not match used API endpoint");
        }
    }
}

