/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.sap.xs.audit.message.Attribute;
import com.sap.xs.audit.message.AuditLogMessageCategory;
import com.sap.xs.audit.message.TransactionalMessage;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.AuditLogMessageValidationUtils;
import com.sap.xs.audit.message.v2.AuditedObjectPOJO;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"uuid", "user", "time", "id", "success", "object_id", "object", "attributes"})
public class ConfigurationChange
extends TransactionalMessage {
    @JsonProperty(value="attributes", required=true)
    private List<Attribute> attributes = new ArrayList<Attribute>();
    @JsonProperty(value="object_id", required=true)
    private String objectId;
    @JsonProperty(value="object", required=true)
    private AuditedObjectPOJO object;

    public ConfigurationChange() {
        super(AuditLogMessageCategory.CONFIGURATION_CHANGE.getCategoryId());
    }

    @JsonIgnore
    public String getObjectId() {
        return this.objectId;
    }

    @JsonIgnore
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @JsonIgnore
    public String getObject() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this.object);
    }

    @JsonIgnore
    public void setObject(AuditedObjectPOJO object) {
        this.object = object;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, String oldValue, String newValue) {
        this.attributes.add(new Attribute(name, oldValue, newValue));
    }

    @Override
    @JsonIgnore
    public void validate() throws ValidationError {
        super.validate();
        this.errors.putAll(AuditLogMessageValidationUtils.validateAttributes(this.attributes, false));
        this.errors.putAll(AuditLogMessageValidationUtils.validateObject(this.object, this.objectId));
        if (this.errors.size() > 0) {
            throw new ValidationError("The audit message contains some invalid properties. For more details use the getErrors() method");
        }
    }
}

