/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.sap.xs.audit.message.Attachment;
import com.sap.xs.audit.message.Attribute;
import com.sap.xs.audit.message.AuditLogMessage;
import com.sap.xs.audit.message.AuditLogMessageCategory;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.AuditLogMessageValidationUtils;
import com.sap.xs.audit.message.v2.AuditedDataSubjectPOJO;
import com.sap.xs.audit.message.v2.AuditedObjectPOJO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uuid", "user", "time", "channel", "object_id", "object", "data_subject", "data_subjects", "attributes", "attachments"})
public class DataAccess
extends AuditLogMessage {
    @JsonProperty(value="channel", required=true)
    private String channel;
    @JsonProperty(value="attributes")
    private List<Attribute> attributes = new ArrayList<Attribute>();
    @JsonProperty(value="attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @JsonProperty(value="object_id", required=true)
    private String objectId;
    @JsonProperty(value="data_subject")
    private AuditedDataSubjectPOJO subject;
    @JsonProperty(value="data_subjects")
    private List<AuditedDataSubjectPOJO> dataSubjects = new ArrayList<AuditedDataSubjectPOJO>();
    @JsonProperty(value="object", required=true)
    private AuditedObjectPOJO object;

    public DataAccess() {
        super(AuditLogMessageCategory.DATA_ACCESS.getCategoryId());
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @JsonIgnore
    public String getObject() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this.object);
    }

    @JsonIgnore
    public void setObject(AuditedObjectPOJO object) {
        this.object = object;
    }

    @JsonIgnore
    public String getDataSubject() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this.subject);
    }

    @JsonIgnore
    public void setDataSubject(AuditedDataSubjectPOJO subject) {
        this.subject = subject;
    }

    public List<AuditedDataSubjectPOJO> getDataSubjects() {
        return this.dataSubjects;
    }

    public void setDataSubjects(List<AuditedDataSubjectPOJO> dataSubjects) {
        this.dataSubjects = dataSubjects;
    }

    public void addDataSubject(AuditedDataSubjectPOJO dataSubject) {
        this.dataSubjects.add(dataSubject);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void addAttribute(String name) {
        this.attributes.add(new Attribute(name));
    }

    public void addAttribute(String name, boolean isSuccessful) {
        this.attributes.add(new Attribute(name, isSuccessful));
    }

    public void addAttachment(String id, String name) {
        this.attachments.add(new Attachment(id, name));
    }

    public void addAttachment(String id, String name, boolean isSuccessful) {
        this.attachments.add(new Attachment(id, name, isSuccessful));
    }

    @Override
    @JsonIgnore
    public void validate() throws ValidationError {
        super.validate();
        this.errors.putAll(AuditLogMessageValidationUtils.validateAttributes(this.attributes, false));
        this.validateAttachments();
        this.errors.putAll(AuditLogMessageValidationUtils.validateObject(this.object, this.objectId));
        this.validateSubject();
        if (this.errors.size() > 0) {
            throw new ValidationError("The audit message contains some invalid properties. For more details use the getErrors() method");
        }
    }

    private void validateSubject() {
        if (this.subject == null && (this.dataSubjects == null || this.dataSubjects.isEmpty())) {
            this.errors.put("subject", "'data_subject' and 'data_subjects' properties cannot be both null or empty");
        } else if (this.dataSubjects != null && this.dataSubjects.size() == 1) {
            if (this.dataSubjects.get(0).getType() == null) {
                this.errors.put("subject.type", "'data_subject.type' property cannot be null or empty");
            }
            if (this.dataSubjects.get(0).getId().size() == 0) {
                this.errors.put("subject.id", "'data_subject.id' property cannot be null or empty");
            }
        } else if (this.dataSubjects != null && this.dataSubjects.size() > 1) {
            for (Attribute attribute : this.attributes) {
                if (attribute.getSuccessful() == null) continue;
                this.errors.put("attribute", "Success on attribute level cannot be set when describing multiple data subjects in one message");
            }
        } else {
            if (this.subject.getType() == null) {
                this.errors.put("subject.type", "'data_subject.type' property cannot be null or empty");
            }
            if (this.subject.getId().size() == 0) {
                this.errors.put("subject.id", "'data_subject.id' property cannot be null or empty");
            }
        }
    }

    private void validateAttachments() {
        if (this.attachments != null && !this.attachments.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>(this.attachments.size() + 1);
            int attachmentIndex = 0;
            for (Attachment attachment : this.attachments) {
                if (attachment.getId() == null) {
                    this.errors.put("id <" + attachmentIndex + ">", "The 'id' property cannot be null");
                } else {
                    ids.add(attachment.getId());
                }
                ++attachmentIndex;
            }
            HashSet uniqueIds = new HashSet(ids);
            if (ids.size() != uniqueIds.size()) {
                this.errors.put("attachments", "'attachments' property should contain uniquie items");
            }
        }
    }
}

