/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sap.xs.audit.message.AuditLogMessage;
import com.sap.xs.audit.message.AuditLogMessageCategory;
import com.sap.xs.audit.message.SecurityAttribute;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.utils.IPValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uuid", "user", "time", "ip", "data", "attributes"})
public class SecurityEvent
extends AuditLogMessage {
    @JsonProperty(value="ip")
    private String ip;
    @JsonProperty(value="data")
    private String data;
    @JsonProperty(value="attributes")
    private List<SecurityAttribute> attributes = new ArrayList<SecurityAttribute>();

    public SecurityEvent() {
        super(AuditLogMessageCategory.SECURITY_EVENT.getCategoryId());
    }

    @JsonProperty(value="ip")
    public String getIp() {
        return this.ip;
    }

    @JsonProperty(value="ip")
    public void setIp(String ip) {
        this.ip = ip;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(String data) {
        this.data = data;
    }

    public void addAttribute(String name, String value) {
        this.attributes.add(new SecurityAttribute(name, value));
    }

    public void setAttributes(List<SecurityAttribute> attributes) {
        this.attributes = attributes;
    }

    public List<SecurityAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonIgnore
    public void validate() throws ValidationError {
        super.validate();
        if (this.ip != null && !IPValidator.isValidIP(this.ip)) {
            this.errors.put("ip", "The 'ip' is not a valid IPv4 or IPv6 address");
        }
        if (this.data == null) {
            this.errors.put("data", "The 'data' property cannot be null");
        }
        if (this.errors.size() > 0) {
            throw new ValidationError("The audit message contains some invalid properties. For more details use the getErrors() method");
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (int index = 0; index < this.attributes.size(); ++index) {
            SecurityAttribute attribute = this.attributes.get(index);
            try {
                attribute.validate();
            }
            catch (ValidationError e) {
                this.errors.put("name <" + index + ">", e.getMessage());
            }
            nameSet.add(attribute.getName());
        }
        if (nameSet.size() != this.attributes.size()) {
            this.errors.put("attributes", "'attributes' property should contain unique items");
        }
    }

    @Override
    @JsonIgnore
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return " ip=" + this.ip + ", data=" + this.data;
    }
}

