/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message.utils;

import com.sap.xs.audit.message.Attribute;
import com.sap.xs.audit.message.ValidationError;
import com.sap.xs.audit.message.v2.AuditedObjectPOJO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AuditLogMessageValidationUtils {
    public static Map<String, String> validateAttributes(List<Attribute> attributes, boolean isDataModification) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (attributes == null || attributes.isEmpty()) {
            errors.put("attributes", "The 'attributes' property cannot be null or empty");
        } else {
            HashSet<String> nameSet = new HashSet<String>();
            for (int index = 0; index < attributes.size(); ++index) {
                Attribute attribute = attributes.get(index);
                try {
                    if (isDataModification) {
                        attribute.validateV2();
                    } else {
                        attribute.validate();
                    }
                }
                catch (ValidationError e) {
                    errors.put("name <" + index + ">", e.getMessage());
                }
                nameSet.add(attribute.getName());
            }
            if (nameSet.size() != attributes.size()) {
                errors.put("attributes", "'attributes' property should contain unique items");
            }
        }
        return errors;
    }

    public static Map<String, String> validateObject(AuditedObjectPOJO object, String objectId) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (object == null) {
            errors.put("object", "'object' property cannot be null or empty");
        } else {
            if (object.getType() == null) {
                errors.put("object.type", "'object.type' property cannot be null or empty");
            }
            if (object.getId() == null || object.getId().size() == 0) {
                errors.put("object.id", "'object.id' property cannot be null or empty");
            }
        }
        if (objectId != null) {
            errors.put("objectId", "'objectId' is not valid attribute for V2 API");
        }
        return errors;
    }
}

