/*
 * Decompiled with CFR 0.152.
 */
package com.sap.xs.audit.message.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;

public class JsonParserUtils {
    static ObjectMapper objectMapper = new ObjectMapper();

    public static String serializeMessage(Object message) throws JsonProcessingException {
        String serializedMessage = objectMapper.writeValueAsString(message);
        return serializedMessage;
    }

    public static <T> T desrializeMessage(String json, Class<T> pojoClass) throws IOException {
        return (T)objectMapper.readValue(json, pojoClass);
    }

    public static String serializeProperties(Object message, String ... properties) throws JsonProcessingException {
        SimpleBeanPropertyFilter propertiesFilter = SimpleBeanPropertyFilter.filterOutAllExcept((String[])properties);
        SimpleFilterProvider filter = new SimpleFilterProvider().addFilter("propertiesFilter", propertiesFilter);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setAnnotationIntrospector(new AnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public Object findFilterId(Annotated a) {
                return "propertiesFilter";
            }

            public Version version() {
                return null;
            }
        });
        String serializedProperties = mapper.writer((FilterProvider)filter).writeValueAsString(message);
        return serializedProperties;
    }

    static {
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

