package com.sap.cds.repackaged.audit.api;

import com.sap.cds.repackaged.audit.api.exception.AuditLogNotAvailableException;
import com.sap.cds.repackaged.audit.api.exception.AuditLogWriteException;

/**
 * This interface provides some transactional logic to the <code>ConfigurationChangeAuditMessage</code>.
 * It allows to clearly indicate whether the audit log event initiated in a previous step has been successful or not.
 */
public interface TransactionalAuditLogMessage extends AuditLogMessage {
	
	/**
	 * Indicates that the audit event is about to happen.
	 * 
	 * @throws AuditLogWriteException If the persistence of the audit event preparation message was unsuccessful
	 * @throws AuditLogNotAvailableException If the audit log server is not available.
	 */
	void logPrepare() throws AuditLogNotAvailableException, AuditLogWriteException;
	
	/**
	 * Indicates that the audit event has been successful.
	 * 
	 * @throws AuditLogWriteException If the persistence of the audit event success message was unsuccessful.
	 * @throws AuditLogNotAvailableException If the audit log server is not available.
	 */
	void logSuccess() throws AuditLogNotAvailableException, AuditLogWriteException;
	
	/**
	 * Indicates that the audit event has failed.
	 * 
	 * @throws AuditLogWriteException If the persistence of the audit event failure message was unsuccessful
	 * @throws AuditLogNotAvailableException If the audit log server is not available.
	 */
	void logFailure() throws AuditLogNotAvailableException, AuditLogWriteException;
}
