package com.sap.cds.repackaged.audit.api.exception;

import java.util.HashMap;
import java.util.Map;

/**
 * This class defines the exception that can be thrown by the logging infrastructure in case
 * the audit log message cannot be delivered to the destination storage.
 * It is strongly recommended to catch this exception and do the necessary to keep
 * the audit log records and the reality consistent. This may include reverting the audited action
 * in case the action cannot be audited.
 * <p>
 * Example:
 * <pre>
 * try {
 *   auditLogMessage.log();
 * } catch (AuditLogWriteRuntimeException auditException) {
 *   // do The Revert Procedure or other actions
 * }
 * </pre>
 */
public class AuditLogWriteException extends AuditLogException {

  private static final long serialVersionUID = -8966993609463751302L;
  private Map<String, String> errors = new HashMap<String, String>();

  /**
   * @see java.lang.RuntimeException
   */
  public AuditLogWriteException() {
    super();
  }

  /**
   * @see java.lang.RuntimeException
   * 
   * @param message Message of the exception.
   * @param exception The exception object.
   */
  public AuditLogWriteException(String message, Throwable exception) {
    super(message, exception);
  }

  /**
   * @see java.lang.RuntimeException
   * 
   * @param message Message of the exception.
   */
  public AuditLogWriteException(String message) {
    super(message);
  }

  /**
   * @see java.lang.RuntimeException
   * 
   * @param exception The exception object.
   */
  public AuditLogWriteException(Throwable exception) {
    super(exception);
  }

  public AuditLogWriteException(String message, Map<String, String> errors) {
    super(message);
    this.errors = errors;
  }

  public Map<String, String> getErrors() {
	  return errors;
  }

  @Override
    public String toString() {
      String returnMessage = super.toString();
      if (errors != null && !errors.isEmpty()) {
        returnMessage += " " + errors;
    }
        return returnMessage;
    }
}
