package com.sap.cds.repackaged.audit.api.v2;

import com.sap.cds.repackaged.audit.api.v2.SecurityEventAuditMessage;

/**
 * Factory interface for audit log messages. The different sub-interfaces of
 * <code>AuditLogMessage</code> represent different sub-categories of the audit log message.
 * <p>
 * Example:
 * <p>
 * <code>
 * ConfigurationChangeAuditMessage message = auditlogmesagefactory.createAuditLogMessage(ConfigurationChangeAuditMessage.class);
 * </code>
 *
 */
public interface AuditLogMessageFactory {
	
	/**
	 * Creates a <code>DataAccessAuditMessage</code> message.
	 * 
	 * @return A new data access message.
	 */
	DataAccessAuditMessage createDataAccessAuditMessage();
	
	/**
	 * Creates a <code>DataModificationAuditMessage</code> message.
	 * 
	 * @return A new data modification message.
	 */
	DataModificationAuditMessage createDataModificationAuditMessage();
	
	/**
	 * Creates a <code>ConfigurationChangeAuditMessage</code> message.
	 * 
	 * @return A new configuration change message.
	 */
	ConfigurationChangeAuditMessage createConfigurationChangeAuditMessage();
	
	/**
	 * Creates a <code>SecurityEventAuditMessage</code> message.
	 * 
	 * @return A new security event message.
	 */
	SecurityEventAuditMessage createSecurityEventAuditMessage();
	
	/**
	 * Creates a <code>AuditedObject</code>.
	 * 
	 * @return A new data object.
	 */
	AuditedObject createAuditedObject();
	
	/**
	 * Creates a <code>AuditedDataSubject</code>.
	 * 
	 * @return A new data subject.
	 */
	AuditedDataSubject createAuditedDataSubject();
	
}
