package com.sap.cds.repackaged.audit.api.v2;

/**
 * A data subject, describing to whom the accessed personal data belongs to, should be provided for the audit log entry.
 * The data subject should look similar to:
 * <pre>
 * {
 *    "type": "testType",
 *    "role": "role",
 *    "id": {
 *      "key1": "value1",
 *      "key2": "value2"
 *    }
 * }</pre>, providing more detailed information on the type of the subject whom the accessed personal data belongs to,
 * their role and information on the key identifiers that identify them.
 **/
public interface AuditedDataSubject {
	
	/**
	 * Adds type to the data subject.
	 * 
	 * @param type Type of the data subject.
	 */
	public void setType(String type);

	/**
	 * Adds role to the data subject.
	 * 
	 * @param role Role of the data subject.
	 */
	public void setRole(String role);

	/**
	 * Adds identifier to the data object.
	 * 
	 * @param key The key of the identifier.
	 * @param value The value of the identifier.
	 */
	public void addIdentifier(String key, String value);
	
}
